/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.virtual.view;

import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.base.BaseLifeCyclePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.virtual.view.ClickView;
import com.immomo.mmpaas.panel.virtual.view.PhoneMarginView;
import com.immomo.mmpaas.panel.virtual.view.VirtualPhoneView;
import com.immomo.mmpaas.utils.ColorConstants;
import com.immomo.mmpaas.utils.LocationUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class PhoneTouchView
extends BaseLifeCyclePanel
implements BroadCastReceiver {
    static final int SIZE_WIDTH = 40;
    static final int SIZE_HEIGHT = 20;
    private static final float MOVE_SPEED = 1.0f;
    private static final int ENTER_THICKNESS = 1;
    private static final int DROP_THICKNESS = 2;
    private ClickView clickedLabel;
    private JLabel enterLabel;
    private JLabel dropLabel;
    private JComponent currentClickView;
    private ClickView clickView;
    private PhoneMarginView phoneMarginView;
    private TouchView panel = new TouchView();

    public PhoneTouchView(Context context2, final VirtualPhoneView virtualPhoneView) {
        super(context2);
        this.panel.setLayout(null);
        this.panel.setOpaque(false);
        this.panel.setBackground(null);
        this.clickedLabel = new ClickView();
        this.clickedLabel.setLayout(null);
        this.clickedLabel.setBackground(ColorConstants.TRANSPARENT);
        this.enterLabel = new JLabel();
        this.enterLabel.setBackground(ColorConstants.TRANSPARENT);
        this.enterLabel.setBorder(new LineBorder(Theme.dark.enterBorderColor, 1, true));
        this.dropLabel = new JLabel();
        this.dropLabel.setBackground(ColorConstants.TRANSPARENT);
        this.dropLabel.setBorder(new LineBorder(Theme.dark.dropEnterBorderColor, 2, true));
        this.clickedLabel.setBounds(0, 0, 0, 0);
        this.dropLabel.setBounds(0, 0, 0, 0);
        this.enterLabel.setBounds(0, 0, 0, 0);
        this.panel.add((Component)this.enterLabel, 0);
        this.panel.add((Component)this.clickedLabel, 0);
        this.panel.add((Component)this.dropLabel, 0);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_CLICK", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_ENTER", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_DROP", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_CLICK_UPDATE", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_CLICK_EXIT", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_ENTER_EXIT", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_DROP_EXIT", this);
        context2.registerReceiver(context2, "BC_PHONE_DELETE", this);
        this.clickedLabel.setFocusable(true);
        this.clickedLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PhoneTouchView.this.currentClickView != null) {
                    if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                        PhoneTouchView.this.handleDelete(virtualPhoneView);
                    } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        PhoneTouchView.this.handleMove(e);
                    }
                }
            }
        });
    }

    public Component getComponent() {
        return this.panel;
    }

    public void destroy() {
        this.context.unregisterReceiver("BC_PHONE_TOUCH_CLICK", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_ENTER", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_DROP", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_CLICK_UPDATE", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_CLICK_EXIT", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_ENTER_EXIT", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_DROP_EXIT", this);
        this.context.unregisterReceiver("BC_PHONE_DELETE", this);
    }

    private void handleDelete(VirtualPhoneView virtualPhoneView) {
        if (this.currentClickView.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)this.currentClickView.getParent();
            viewGroup.remove(this.currentClickView);
            viewGroup.requestLayout();
        }
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_HIERARCHY_EXIT"));
        this.context.sendBroadCastMessageAsync(BroadCastMessage.obtain("BC_WINDOW_TREE_UPDATE", virtualPhoneView.getLuaContainer()));
        this.context.sendBroadCastMessageAsync(BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK_EXIT"));
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_PROPERTY_DISPLAY"));
    }

    private void handleMove(KeyEvent e) {
        IView view = (IView)((Object)this.currentClickView);
        if (e.getKeyCode() == 38) {
            double marginTop = view.getViewWrapper().getOriginMarginTop() - 1.0;
            view.setMarginTop(marginTop < 0.0 ? 0.0 : marginTop);
        }
        if (e.getKeyCode() == 40) {
            view.setMarginTop(view.getViewWrapper().getOriginMarginTop() + 1.0);
        }
        if (e.getKeyCode() == 37) {
            double marginLeft = view.getViewWrapper().getOriginMarginLeft() - 1.0;
            view.setMarginLeft(marginLeft < 0.0 ? 0.0 : marginLeft);
        }
        if (e.getKeyCode() == 39) {
            view.setMarginLeft(view.getViewWrapper().getOriginMarginLeft() + 1.0);
        }
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_HIERARCHY_EXIT"));
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK_UPDATE", view));
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_PROPERTY_UPDATE", view));
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_PHONE_TOUCH_CLICK": {
                this.currentClickView = (JComponent)msg.msg;
                this.clickedLabel.requestFocus();
            }
            case "BC_PHONE_TOUCH_CLICK_UPDATE": {
                this.currentClickView = (JComponent)msg.msg;
            }
            case "BC_PHONE_TOUCH_ENTER": 
            case "BC_PHONE_TOUCH_DROP": {
                int height;
                int width;
                int y;
                int x;
                JComponent targetComponent;
                JComponent targetLabel;
                JComponent component = (JComponent)msg.msg;
                if ("BC_PHONE_TOUCH_DROP".equals(msg.key)) {
                    targetLabel = this.dropLabel;
                    targetComponent = component instanceof ViewGroup ? component : (JComponent)component.getParent();
                } else if ("BC_PHONE_TOUCH_ENTER".equals(msg.key)) {
                    targetLabel = this.enterLabel;
                    targetComponent = component;
                } else {
                    targetLabel = this.clickedLabel;
                    targetComponent = component;
                }
                if (component instanceof LuaWindow) {
                    x = component.getX();
                    y = component.getY();
                    width = targetComponent.getWidth();
                    height = targetComponent.getHeight();
                } else {
                    x = LocationUtil.getAbsolutelyX(targetComponent);
                    y = LocationUtil.getAbsolutelyY(targetComponent);
                    width = targetComponent.getWidth();
                    height = targetComponent.getHeight();
                }
                targetLabel.setBounds(x + 40 + 2, y + 20 + 2, width, height);
                if (msg.key.equals("BC_PHONE_TOUCH_CLICK") || msg.key.equals("BC_PHONE_TOUCH_CLICK_UPDATE")) {
                    this.clickView = (ClickView)targetLabel;
                    this.clickView.setWidthHeightVisible(true);
                }
                if (this.phoneMarginView != null) {
                    this.panel.remove(this.phoneMarginView);
                    this.panel.revalidate();
                    this.panel.repaint();
                }
                if (!msg.key.equals("BC_PHONE_TOUCH_ENTER") || this.currentClickView == null) break;
                this.clickView.setWidthHeightVisible(false);
                this.phoneMarginView = new PhoneMarginView();
                this.phoneMarginView.setBounds(0, 0, this.panel.getWidth(), this.panel.getHeight());
                this.phoneMarginView.setTargetComponent(this.clickView, targetLabel);
                this.phoneMarginView.setOpaque(false);
                this.panel.add((Component)this.phoneMarginView, 0);
                break;
            }
            case "BC_PHONE_TOUCH_CLICK_EXIT": {
                this.clickedLabel.setBounds(0, 0, 0, 0);
                this.clickedLabel.repaint();
                this.currentClickView = null;
                this.removeMarginView();
                break;
            }
            case "BC_PHONE_TOUCH_ENTER_EXIT": {
                this.enterLabel.setBounds(0, 0, 0, 0);
                this.enterLabel.repaint();
                if (this.clickView != null) {
                    this.clickView.setWidthHeightVisible(true);
                }
                this.removeMarginView();
                break;
            }
            case "BC_PHONE_TOUCH_DROP_EXIT": {
                this.dropLabel.setBounds(0, 0, 0, 0);
                this.dropLabel.repaint();
            }
        }
        return false;
    }

    private void removeMarginView() {
        if (this.phoneMarginView != null) {
            this.panel.remove(this.phoneMarginView);
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    private static class TouchView
    extends JPanel {
        private TouchView() {
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x - 40 - 2, y - 20 - 2, width + 80 + 4, height + 40 + 4);
        }
    }
}

