/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.virtual.view;

import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mmpaas.base.Theme;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PhoneMarginView
extends JPanel {
    private int MARGIN_SIZE_WIDTH = 42;
    private int MARGIN_SIZE_HEIGHT = 22;
    private Point clickLeftTop;
    private Point clickRightTop;
    private Point clickLeftBottom;
    private Point clickRightBottom;
    private Point enterLeftTop;
    private Point enterRightTop;
    private Point enterLeftBottom;
    private Point enterRightBottom;
    private int clickWidth;
    private int clickHeight;
    private int enterWidth;
    private int enterHeight;
    private Component clickView;
    private Component enterView;
    private int separationWidth = 3;

    public void setTargetComponent(Component clickView, Component enterView) {
        this.clickView = clickView;
        this.enterView = enterView;
        this.clickWidth = clickView.getWidth() - 80 - 4;
        this.clickHeight = clickView.getHeight() - 40 - 4;
        this.clickLeftTop = new Point(clickView.getX() + 40 + 2, clickView.getY() + 20 + 2);
        this.clickRightTop = new Point(clickView.getX() + 40 + 2 + this.clickWidth, clickView.getY() + 20 + 2);
        this.clickLeftBottom = new Point(clickView.getX() + 40 + 2, clickView.getY() + 20 + 2 + this.clickHeight);
        this.clickRightBottom = new Point(clickView.getX() + 40 + 2 + this.clickWidth, clickView.getY() + 20 + 2 + this.clickHeight);
        this.enterLeftTop = new Point(enterView.getX(), enterView.getY());
        this.enterRightTop = new Point(enterView.getX() + enterView.getWidth(), enterView.getY());
        this.enterLeftBottom = new Point(enterView.getX(), enterView.getY() + enterView.getHeight());
        this.enterRightBottom = new Point(enterView.getX() + enterView.getWidth(), enterView.getY() + enterView.getHeight());
        this.enterWidth = enterView.getWidth();
        this.enterHeight = enterView.getHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.clickView == null || this.enterView == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        this.removeAll();
        if (this.clickLeftTop.x <= this.enterLeftTop.x && this.clickLeftTop.y <= this.enterLeftTop.y && this.clickRightTop.x >= this.enterRightTop.x && this.clickRightTop.y <= this.enterRightTop.y && this.clickLeftBottom.x <= this.enterLeftBottom.x && this.clickLeftBottom.y >= this.enterLeftBottom.y && this.clickRightBottom.x >= this.enterRightBottom.x && this.clickRightBottom.y >= this.enterRightBottom.y || this.enterLeftTop.x <= this.clickLeftTop.x && this.enterLeftTop.y <= this.clickLeftTop.y && this.enterRightTop.x >= this.clickRightTop.x && this.enterRightTop.y <= this.clickRightTop.y && this.enterLeftBottom.x <= this.clickLeftBottom.x && this.enterLeftBottom.y >= this.clickLeftBottom.y && this.enterRightBottom.x >= this.clickRightBottom.x && this.enterRightBottom.y >= this.clickRightBottom.y) {
            this.showContainLabel(g2d);
        } else if (this.enterLeftBottom.y <= this.clickLeftTop.y && this.enterLeftTop.x >= this.clickLeftTop.x && this.enterRightTop.x <= this.clickRightTop.x || this.clickLeftBottom.y <= this.enterLeftTop.y && this.clickLeftTop.x >= this.enterLeftTop.x && this.clickRightTop.x <= this.enterRightTop.x || this.enterLeftTop.y >= this.clickLeftBottom.y && this.enterLeftTop.x >= this.clickLeftTop.x && this.enterRightTop.x <= this.clickRightTop.x || this.clickLeftTop.y >= this.enterLeftBottom.y && this.clickLeftTop.x >= this.enterLeftTop.x && this.clickRightTop.x <= this.enterRightTop.x) {
            this.showTopBottomView(g2d);
        } else if (this.enterLeftTop.x >= this.clickRightTop.x && this.enterLeftTop.y <= this.clickLeftTop.y && this.enterLeftBottom.y >= this.clickLeftBottom.y || this.clickLeftTop.x >= this.enterRightTop.x && this.clickLeftTop.y <= this.enterLeftTop.y && this.clickLeftBottom.y >= this.enterLeftBottom.y || this.enterRightTop.x <= this.clickLeftTop.x && this.enterRightTop.y <= this.clickLeftTop.y && this.enterLeftBottom.y >= this.clickLeftBottom.y || this.clickRightTop.x <= this.enterLeftTop.x && this.clickRightTop.y <= this.enterLeftTop.y && this.clickLeftBottom.y >= this.enterLeftBottom.y) {
            this.showLeftRightLabel(g2d);
        } else if (this.enterRightBottom.x <= this.clickLeftTop.x && this.enterRightBottom.y <= this.clickLeftTop.y || this.enterLeftTop.x >= this.clickRightBottom.x && this.enterLeftTop.y >= this.clickRightBottom.y || this.enterRightTop.x <= this.clickLeftBottom.x && this.enterRightTop.y >= this.clickLeftBottom.y || this.enterLeftBottom.x >= this.clickRightTop.x && this.enterRightBottom.y <= this.clickRightTop.y) {
            this.setNoIntersect(g2d);
        } else {
            this.setIntersect(g2d);
        }
    }

    private void setNoIntersect(Graphics2D g2d) {
        Point clickCenter = new Point(this.clickLeftTop.x + this.clickWidth / 2, this.clickLeftTop.y + this.clickHeight / 2);
        int topLeftLength = (int)(Math.pow(Math.abs(clickCenter.x - this.enterLeftTop.x), 2.0) + Math.pow(Math.abs(clickCenter.y - this.enterLeftTop.y), 2.0));
        int topRightLength = (int)(Math.pow(Math.abs(clickCenter.x - this.enterRightTop.x), 2.0) + Math.pow(Math.abs(clickCenter.y - this.enterRightTop.y), 2.0));
        int bottomLeftLength = (int)(Math.pow(Math.abs(clickCenter.x - this.enterLeftBottom.x), 2.0) + Math.pow(Math.abs(clickCenter.y - this.enterLeftBottom.y), 2.0));
        int bottomRightLength = (int)(Math.pow(Math.abs(clickCenter.x - this.enterRightBottom.x), 2.0) + Math.pow(Math.abs(clickCenter.y - this.enterRightBottom.y), 2.0));
        int shortestDistance = Math.min(Math.min(Math.min(topLeftLength, topRightLength), bottomLeftLength), bottomRightLength);
        Point targetPoint = shortestDistance == topLeftLength ? this.enterLeftTop : (shortestDistance == topRightLength ? this.enterRightTop : (shortestDistance == bottomLeftLength ? this.enterLeftBottom : this.enterRightBottom));
        int width = Math.abs(clickCenter.x - targetPoint.x);
        int height = Math.abs(clickCenter.y - targetPoint.y);
        int hx1 = clickCenter.x;
        int hy1 = targetPoint.y > clickCenter.y ? this.clickLeftBottom.y : this.clickLeftTop.y;
        int hx2 = clickCenter.x;
        int hy2 = targetPoint.y;
        this.ShowMarginLabel(g2d, hx1, hy1, hx2, hy2);
        int vx1 = targetPoint.x > clickCenter.x ? this.clickRightTop.x : this.clickLeftTop.x;
        int vy1 = clickCenter.y;
        int vx2 = targetPoint.x;
        int vy2 = clickCenter.y;
        this.ShowMarginLabel(g2d, vx1, vy1, vx2, vy2);
        this.showDottedLine(g2d, targetPoint.x, targetPoint.y, targetPoint.x < clickCenter.x ? targetPoint.x + width : targetPoint.x - width, targetPoint.y);
        this.showDottedLine(g2d, targetPoint.x, targetPoint.y, targetPoint.x, targetPoint.y > clickCenter.y ? targetPoint.y - height : targetPoint.y + height);
    }

    private JLabel getLabel() {
        JLabel label2 = new JLabel();
        label2.setBackground(Theme.dark.phoneClickColor);
        label2.setOpaque(true);
        label2.setForeground(Theme.dark.phoneShowColor);
        label2.setHorizontalAlignment(0);
        label2.setVerticalAlignment(0);
        return label2;
    }

    private void ShowMarginLabel(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        int labelY;
        int labelX;
        JLabel label2;
        if (y1 == y2 && x2 == x1) {
            return;
        }
        g2d.setColor(Theme.dark.phoneLinkLineColor);
        if (y1 == y2) {
            if (x2 > x1) {
                g2d.drawLine(x1, y1 - this.separationWidth, x1, y1 + this.separationWidth);
            } else {
                g2d.drawLine(x1, y1 - this.separationWidth, x1, y1 + this.separationWidth);
            }
            g2d.drawLine(x1, y1, x2, y2);
            if (x2 > x1) {
                g2d.drawLine(x2, y2 - this.separationWidth, x2, y2 + this.separationWidth);
            } else {
                g2d.drawLine(x2, y2 - this.separationWidth, x2, y2 + this.separationWidth);
            }
            label2 = this.getLabel();
            labelX = (x1 + x2) / 2 - this.MARGIN_SIZE_WIDTH / 2;
            labelY = y1 + 2;
            label2.setBounds(labelX, labelY, this.MARGIN_SIZE_WIDTH, this.MARGIN_SIZE_HEIGHT);
            label2.setText(String.valueOf(DimenUtil.pxToDp(Math.abs(x2 - x1))));
            this.add(label2);
        }
        if (x1 == x2) {
            if (y2 > y1) {
                g2d.drawLine(x1 - this.separationWidth, y1, x1 + this.separationWidth, y1);
            } else {
                g2d.drawLine(x1 - this.separationWidth, y1, x1 + this.separationWidth, y1);
            }
            g2d.drawLine(x1, y1, x2, y2);
            if (y2 > y1) {
                g2d.drawLine(x2 - this.separationWidth, y2, x2 + this.separationWidth, y2);
            } else {
                g2d.drawLine(x2 - this.separationWidth, y2, x2 + this.separationWidth, y2);
            }
            label2 = this.getLabel();
            labelX = x1 + 2;
            labelY = (y1 + y2) / 2 - this.MARGIN_SIZE_HEIGHT / 2;
            label2.setBounds(labelX, labelY, this.MARGIN_SIZE_WIDTH, this.MARGIN_SIZE_HEIGHT);
            label2.setText(String.valueOf(DimenUtil.pxToDp(Math.abs(y2 - y1))));
            this.add(label2);
        }
    }

    private void showDottedLine(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        float[] dash1 = new float[]{2.0f, 0.0f, 2.0f};
        BasicStroke bs1 = new BasicStroke(1.0f, 0, 1, 1.0f, dash1, 2.0f);
        g2d.setStroke(bs1);
        g2d.setColor(Theme.dark.phoneDottedLineColor);
        g2d.drawLine(x1, y1, x2, y2);
    }

    private void showContainLabel(Graphics2D g2d) {
        int targetHeight;
        int targetWidth;
        int sourceHeight;
        int sourceWidth;
        Point targetPoint;
        Point sourcePoint;
        int clickArea = this.clickHeight * this.clickWidth;
        int enterArea = this.enterHeight * this.enterWidth;
        if (clickArea > enterArea) {
            sourcePoint = new Point(this.enterView.getX(), this.enterView.getY());
            targetPoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            sourceWidth = this.enterView.getWidth();
            sourceHeight = this.enterView.getHeight();
            targetWidth = this.clickView.getWidth() - 80 - 4;
            targetHeight = this.clickView.getHeight() - 40 - 4;
        } else {
            sourcePoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            targetPoint = new Point(this.enterView.getX(), this.enterView.getY());
            sourceWidth = this.clickView.getWidth() - 80 - 4;
            sourceHeight = this.clickView.getHeight() - 40 - 4;
            targetWidth = this.enterView.getWidth();
            targetHeight = this.enterView.getHeight();
        }
        Point centerPoint = new Point(sourcePoint.x + sourceWidth / 2, sourcePoint.y + sourceHeight / 2);
        int topX1 = centerPoint.x;
        int topY1 = sourcePoint.y;
        int topX2 = centerPoint.x;
        int topY2 = targetPoint.y;
        this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
        int leftX1 = sourcePoint.x;
        int leftY1 = centerPoint.y;
        int leftX2 = targetPoint.x;
        int leftY2 = centerPoint.y;
        this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
        int rightX1 = sourcePoint.x + sourceWidth;
        int rightY1 = centerPoint.y;
        int rightX2 = targetPoint.x + targetWidth;
        int rightY2 = centerPoint.y;
        this.ShowMarginLabel(g2d, rightX1, rightY1, rightX2, rightY2);
        int bottomX1 = centerPoint.x;
        int bottomY1 = sourcePoint.y + sourceHeight;
        int bottomX2 = centerPoint.x;
        int bottomY2 = targetPoint.y + targetHeight;
        this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
    }

    private void showLeftRightLabel(Graphics2D g2d) {
        int targetHeight;
        int targetWidth;
        int sourceHeight;
        int sourceWidth;
        Point targetPoint;
        Point sourcePoint;
        if (this.clickLeftTop.y <= this.enterLeftTop.y && this.clickLeftBottom.y >= this.enterLeftBottom.y) {
            sourcePoint = new Point(this.enterView.getX(), this.enterView.getY());
            targetPoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            sourceWidth = this.enterView.getWidth();
            sourceHeight = this.enterView.getHeight();
            targetWidth = this.clickView.getWidth() - 80 - 4;
            targetHeight = this.clickView.getHeight() - 40 - 4;
        } else {
            sourcePoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            targetPoint = new Point(this.enterView.getX(), this.enterView.getY());
            sourceWidth = this.clickView.getWidth() - 80 - 4;
            sourceHeight = this.clickView.getHeight() - 40 - 4;
            targetWidth = this.enterView.getWidth();
            targetHeight = this.enterView.getHeight();
        }
        Point centerPoint = new Point(sourcePoint.x + sourceWidth / 2, sourcePoint.y + sourceHeight / 2);
        int topX1 = centerPoint.x;
        int topY1 = sourcePoint.y;
        int topX2 = centerPoint.x;
        int topY2 = targetPoint.y;
        this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
        int bottomX1 = centerPoint.x;
        int bottomY1 = sourcePoint.y + sourceHeight;
        int bottomX2 = centerPoint.x;
        int bottomY2 = targetPoint.y + targetHeight;
        this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
        if (sourcePoint.x > targetPoint.x) {
            int leftX1 = sourcePoint.x;
            int leftY1 = centerPoint.y;
            int leftX2 = targetPoint.x + targetWidth;
            int leftY2 = centerPoint.y;
            this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
            if (sourcePoint.y != targetPoint.y) {
                this.showDottedLine(g2d, topX2, topY2, targetPoint.x + targetWidth, targetPoint.y);
            }
            if (sourcePoint.y + sourceHeight != targetPoint.y + targetHeight) {
                this.showDottedLine(g2d, bottomX2, bottomY2, targetPoint.x + targetWidth, targetPoint.y + targetHeight);
            }
        } else {
            int leftX1 = sourcePoint.x + sourceWidth;
            int leftY1 = centerPoint.y;
            int leftX2 = targetPoint.x;
            int leftY2 = centerPoint.y;
            this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
            if (sourcePoint.y != targetPoint.y) {
                this.showDottedLine(g2d, topX2, topY2, targetPoint.x, targetPoint.y);
            }
            if (sourcePoint.y + sourceHeight != targetPoint.y + targetHeight) {
                this.showDottedLine(g2d, bottomX2, bottomY2, targetPoint.x, targetPoint.y + targetHeight);
            }
        }
    }

    private void showTopBottomView(Graphics2D g2d) {
        int targetHeight;
        int targetWidth;
        int sourceHeight;
        int sourceWidth;
        Point targetPoint;
        Point sourcePoint;
        if (this.clickLeftTop.x <= this.enterLeftTop.x && this.clickRightTop.x >= this.enterRightTop.x) {
            sourcePoint = new Point(this.enterView.getX(), this.enterView.getY());
            targetPoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            sourceWidth = this.enterView.getWidth();
            sourceHeight = this.enterView.getHeight();
            targetWidth = this.clickView.getWidth() - 80 - 4;
            targetHeight = this.clickView.getHeight() - 40 - 4;
        } else {
            sourcePoint = new Point(this.clickView.getX() + 40 + 2, this.clickView.getY() + 20 + 2);
            targetPoint = new Point(this.enterView.getX(), this.enterView.getY());
            sourceWidth = this.clickView.getWidth() - 80 - 4;
            sourceHeight = this.clickView.getHeight() - 40 - 4;
            targetWidth = this.enterView.getWidth();
            targetHeight = this.enterView.getHeight();
        }
        Point centerPoint = new Point(sourcePoint.x + sourceWidth / 2, sourcePoint.y + sourceHeight / 2);
        int leftX1 = sourcePoint.x;
        int leftY1 = centerPoint.y;
        int leftX2 = targetPoint.x;
        int leftY2 = centerPoint.y;
        this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
        int rightX1 = sourcePoint.x + sourceWidth;
        int rightY1 = centerPoint.y;
        int rightX2 = targetPoint.x + targetWidth;
        int rightY2 = centerPoint.y;
        this.ShowMarginLabel(g2d, rightX1, rightY1, rightX2, rightY2);
        if (sourcePoint.y < targetPoint.y) {
            int bottomX1 = centerPoint.x;
            int bottomY1 = sourcePoint.y + sourceHeight;
            int bottomX2 = centerPoint.x;
            int bottomY2 = targetPoint.y;
            this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
            if (sourcePoint.x != targetPoint.x) {
                this.showDottedLine(g2d, leftX2, leftY2, targetPoint.x, targetPoint.y);
            }
            if (sourcePoint.x + sourceWidth != targetPoint.x + targetWidth) {
                this.showDottedLine(g2d, rightX2, rightY2, targetPoint.x + targetWidth, targetPoint.y);
            }
        } else {
            int bottomX1 = centerPoint.x;
            int bottomY1 = sourcePoint.y;
            int bottomX2 = centerPoint.x;
            int bottomY2 = targetPoint.y + targetHeight;
            this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
            if (sourcePoint.x != targetPoint.x) {
                this.showDottedLine(g2d, leftX2, leftY2, targetPoint.x, targetPoint.y + targetHeight);
            }
            if (sourcePoint.x + sourceWidth != targetPoint.x + targetWidth) {
                this.showDottedLine(g2d, rightX2, rightY2, targetPoint.x + targetWidth, targetPoint.y + targetHeight);
            }
        }
    }

    private void setIntersect(Graphics2D g2d) {
        if (this.enterRightBottom.x >= this.clickLeftTop.x && this.enterRightBottom.y <= this.clickLeftTop.y && this.enterRightBottom.x <= this.clickRightTop.x || this.enterRightTop.x >= this.clickLeftBottom.x && this.enterLeftTop.y >= this.clickLeftBottom.y && this.enterRightTop.x <= this.clickRightBottom.x) {
            int rightX1 = this.enterRightTop.x;
            int rightY1 = this.enterLeftTop.y + this.enterHeight / 2;
            int rightX2 = this.clickLeftTop.x + this.clickWidth;
            int rightY2 = this.enterLeftTop.y + this.enterHeight / 2;
            this.ShowMarginLabel(g2d, rightX1, rightY1, rightX2, rightY2);
            int leftX1 = this.clickLeftTop.x;
            int leftY1 = this.clickLeftTop.y + this.clickHeight / 2;
            int leftX2 = this.enterLeftTop.x;
            int leftY2 = this.clickLeftTop.y + this.clickHeight / 2;
            this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
            if (this.enterLeftBottom.y <= this.clickLeftTop.y) {
                int topX1 = this.enterRightBottom.x - (this.enterRightBottom.x - this.clickLeftTop.x) / 2;
                int topY1 = this.enterRightBottom.y;
                int topX2 = this.enterRightBottom.x - (this.enterRightBottom.x - this.clickLeftTop.x) / 2;
                int topY2 = this.clickLeftTop.y;
                this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
                this.showDottedLine(g2d, rightX2, rightY2, this.clickRightTop.x, this.clickRightTop.y);
                this.showDottedLine(g2d, leftX2, leftY2, this.enterLeftBottom.x, this.enterLeftBottom.y);
            } else {
                int topX1 = this.enterRightBottom.x - (this.enterRightBottom.x - this.clickLeftTop.x) / 2;
                int topY1 = this.enterRightTop.y;
                int topX2 = this.enterRightBottom.x - (this.enterRightBottom.x - this.clickLeftTop.x) / 2;
                int topY2 = this.clickLeftBottom.y;
                this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
                this.showDottedLine(g2d, rightX2, rightY2, this.clickRightBottom.x, this.clickRightBottom.y);
                this.showDottedLine(g2d, leftX2, leftY2, this.enterLeftTop.x, this.enterLeftTop.y);
            }
        } else if (this.clickRightBottom.x >= this.enterLeftTop.x && this.clickRightBottom.y <= this.enterLeftTop.y && this.clickRightBottom.x <= this.enterRightTop.x || this.clickRightTop.x >= this.enterLeftBottom.x && this.clickLeftTop.y >= this.enterLeftBottom.y && this.clickRightTop.x <= this.enterRightBottom.x) {
            int rightX1 = this.clickRightTop.x;
            int rightY1 = this.clickLeftTop.y + this.clickHeight / 2;
            int rightX2 = this.enterRightTop.x;
            int rightY2 = this.clickLeftTop.y + this.clickHeight / 2;
            this.ShowMarginLabel(g2d, rightX1, rightY1, rightX2, rightY2);
            int leftX1 = this.enterLeftTop.x;
            int leftY1 = this.enterLeftTop.y + this.enterHeight / 2;
            int leftX2 = this.clickLeftTop.x;
            int leftY2 = this.enterLeftTop.y + this.enterHeight / 2;
            this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
            if (this.clickLeftBottom.y <= this.enterLeftTop.y) {
                int topX1 = this.clickRightBottom.x - (this.clickRightBottom.x - this.enterLeftTop.x) / 2;
                int topY1 = this.clickRightBottom.y;
                int topX2 = this.clickRightBottom.x - (this.clickRightBottom.x - this.enterLeftTop.x) / 2;
                int topY2 = this.enterLeftTop.y;
                this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
                this.showDottedLine(g2d, rightX2, rightY2, this.enterRightTop.x, this.enterRightTop.y);
                this.showDottedLine(g2d, leftX2, leftY2, this.clickLeftBottom.x, this.clickLeftBottom.y);
            } else {
                int topX1 = this.clickRightBottom.x - (this.clickRightBottom.x - this.enterLeftTop.x) / 2;
                int topY1 = this.clickRightTop.y;
                int topX2 = this.clickRightBottom.x - (this.clickRightBottom.x - this.enterLeftTop.x) / 2;
                int topY2 = this.enterLeftBottom.y;
                this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
                this.showDottedLine(g2d, rightX2, rightY2, this.enterRightBottom.x, this.enterRightBottom.y);
                this.showDottedLine(g2d, leftX2, leftY2, this.clickLeftTop.x, this.clickLeftTop.y);
            }
        } else if (this.enterRightBottom.x <= this.clickLeftTop.x && this.enterRightBottom.y >= this.clickLeftTop.y && this.enterLeftBottom.y <= this.clickLeftBottom.y || this.enterLeftBottom.x >= this.clickRightTop.x && this.enterLeftBottom.y >= this.clickRightTop.y && this.enterLeftBottom.y <= this.clickRightBottom.y) {
            int topX1 = this.clickLeftTop.x + this.clickWidth / 2;
            int topY1 = this.clickLeftTop.y;
            int topX2 = this.clickLeftTop.x + this.clickWidth / 2;
            int topY2 = this.enterLeftTop.y;
            this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
            int bottomX1 = this.enterLeftBottom.x + this.enterWidth / 2;
            int bottomY1 = this.enterLeftBottom.y;
            int bottomX2 = this.enterLeftBottom.x + this.enterWidth / 2;
            int bottomY2 = this.clickLeftBottom.y;
            this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
            if (this.enterRightTop.x <= this.clickLeftBottom.x) {
                int leftX1 = this.enterRightTop.x;
                int leftY1 = this.enterRightBottom.y - (this.enterRightBottom.y - this.clickLeftTop.y) / 2;
                int leftX2 = this.clickLeftTop.x;
                int leftY2 = this.enterRightBottom.y - (this.enterRightBottom.y - this.clickLeftTop.y) / 2;
                this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
                this.showDottedLine(g2d, topX2, topY2, this.enterRightTop.x, this.enterRightTop.y);
                this.showDottedLine(g2d, bottomX2, bottomY2, this.clickLeftBottom.x, this.clickLeftBottom.y);
            } else {
                int leftX1 = this.enterLeftTop.x;
                int leftY1 = this.enterRightBottom.y - (this.enterRightBottom.y - this.clickLeftTop.y) / 2;
                int leftX2 = this.clickRightTop.x;
                int leftY2 = this.enterRightBottom.y - (this.enterRightBottom.y - this.clickLeftTop.y) / 2;
                this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
                this.showDottedLine(g2d, topX2, topY2, this.enterLeftTop.x, this.enterLeftTop.y);
                this.showDottedLine(g2d, bottomX2, bottomY2, this.clickRightBottom.x, this.clickRightBottom.y);
            }
        } else if (this.clickRightBottom.x <= this.enterLeftTop.x && this.clickRightBottom.y >= this.enterLeftTop.y && this.clickLeftBottom.y <= this.enterLeftBottom.y || this.clickLeftBottom.x >= this.enterRightTop.x && this.clickLeftBottom.y >= this.enterRightTop.y && this.clickLeftBottom.y <= this.enterRightBottom.y) {
            int topX1 = this.enterLeftTop.x + this.enterWidth / 2;
            int topY1 = this.enterLeftTop.y;
            int topX2 = this.enterLeftTop.x + this.enterWidth / 2;
            int topY2 = this.clickLeftTop.y;
            this.ShowMarginLabel(g2d, topX1, topY1, topX2, topY2);
            int bottomX1 = this.clickLeftBottom.x + this.clickWidth / 2;
            int bottomY1 = this.clickLeftBottom.y;
            int bottomX2 = this.clickLeftBottom.x + this.clickWidth / 2;
            int bottomY2 = this.enterLeftBottom.y;
            this.ShowMarginLabel(g2d, bottomX1, bottomY1, bottomX2, bottomY2);
            if (this.clickRightTop.x <= this.enterLeftBottom.x) {
                int leftX1 = this.clickRightTop.x;
                int leftY1 = this.clickRightBottom.y - (this.clickRightBottom.y - this.enterLeftTop.y) / 2;
                int leftX2 = this.enterLeftTop.x;
                int leftY2 = this.clickRightBottom.y - (this.clickRightBottom.y - this.enterLeftTop.y) / 2;
                this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
                this.showDottedLine(g2d, topX2, topY2, this.clickRightTop.x, this.clickRightTop.y);
                this.showDottedLine(g2d, bottomX2, bottomY2, this.enterLeftBottom.x, this.enterLeftBottom.y);
            } else {
                int leftX1 = this.clickLeftTop.x;
                int leftY1 = this.clickRightBottom.y - (this.clickRightBottom.y - this.enterLeftTop.y) / 2;
                int leftX2 = this.enterRightTop.x;
                int leftY2 = this.clickRightBottom.y - (this.clickRightBottom.y - this.enterLeftTop.y) / 2;
                this.ShowMarginLabel(g2d, leftX1, leftY1, leftX2, leftY2);
                this.showDottedLine(g2d, topX2, topY2, this.clickLeftTop.x, this.clickLeftTop.y);
                this.showDottedLine(g2d, bottomX2, bottomY2, this.enterRightBottom.x, this.enterRightBottom.y);
            }
        }
    }
}

