/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.virtual.view;

import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.BaseLifeCyclePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.ComponentDragHelper;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.source.DragSourceHandler;
import com.immomo.mmpaas.panel.virtual.view.ComponentTransferable;
import com.immomo.mmpaas.utils.LocationUtil;
import com.immomo.mmpaas.utils.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class HierarchyView
extends BaseLifeCyclePanel
implements BroadCastReceiver {
    private static int BORDER_THICKNESS = 1;
    private Map<String, IView> maps;
    private MouseListener mouseListener;
    private JPanel panel = new JPanel();

    public HierarchyView(Context context2, final Container container) {
        super(context2);
        this.panel.setLayout(null);
        this.panel.setOpaque(false);
        this.panel.setBackground(null);
        this.maps = new HashMap<String, IView>();
        context2.registerReceiver(context2, "BC_HIERARCHY_EXIT", this);
        ComponentDragHelper.setDragSource(this.panel, new SourceDragHandler(this.panel));
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Log.e("window", new Object[0]);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                HierarchyView.this.panel.removeAll();
                for (Component component : container.getComponents()) {
                    if (!(component instanceof LuaWindow)) continue;
                    HierarchyView.this.addHierarchyView((Container)component, container);
                }
                HierarchyView.this.panel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.panel.addMouseListener(this.mouseListener);
    }

    public void destroy() {
        BroadCastManager.getManager().unregisterReceiver("BC_HIERARCHY_EXIT", this);
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_HIERARCHY_EXIT": {
                this.panel.removeAll();
                this.panel.repaint();
                BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_ENTER_EXIT", null));
            }
        }
        return false;
    }

    public Component getComponent() {
        return this.panel;
    }

    private void addHierarchyView(Container container, Container root) {
        if (container instanceof LuaWindow) {
            this.panel.add((Component)this.getHierarchyLabel(container, root), 0);
        }
        for (Component component : container.getComponents()) {
            this.panel.add((Component)this.getHierarchyLabel(component, root), 0);
            if (!(component instanceof ViewGroup)) continue;
            this.addHierarchyView((Container)component, root);
        }
    }

    private JLabel getHierarchyLabel(Component jComponent, Container root) {
        JLabel label2 = new JLabel();
        label2.setBackground(null);
        label2.setOpaque(false);
        label2.setBorder(new LineBorder(Theme.dark.hierarchyBorderColor, BORDER_THICKNESS));
        label2.setBounds(LocationUtil.getAbsolutelyX(jComponent, root), LocationUtil.getAbsolutelyY(jComponent, root), jComponent.getWidth(), jComponent.getHeight());
        this.maps.put(label2.hashCode() + "", (IView)((Object)jComponent));
        if (label2.getMouseListeners().length == 0) {
            label2.addMouseMotionListener(new CustomerMouseAdapter());
            label2.addMouseListener(new CustomerMouseAdapter());
        }
        return label2;
    }

    public class SourceDragHandler
    implements DragGestureListener {
        private JPanel container;
        private Point point = new Point(0, 0);

        public SourceDragHandler(JPanel jPanel) {
            this.container = jPanel;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JLabel jLabel = (JLabel)this.container.getComponentAt(dge.getDragOrigin());
            ComponentTransferable t = new ComponentTransferable(jLabel);
            DragSource ds = dge.getDragSource();
            BufferedImage img = new BufferedImage(jLabel.getWidth(), jLabel.getHeight(), 1);
            ds.startDrag(dge, null, img, this.point, t, new DragSourceHandler());
        }
    }

    class CustomerMouseAdapter
    extends MouseAdapter {
        CustomerMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK", HierarchyView.this.maps.get(e.getSource().hashCode() + "")));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_ENTER", HierarchyView.this.maps.get(e.getSource().hashCode() + "")));
            ((JLabel)e.getSource()).setToolTipText(((IView)HierarchyView.this.maps.get(e.getSource().hashCode() + "")).getLuaClassName());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
        }
    }
}

