/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.virtual;

import com.immomo.mlservics.LuaInstance;
import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.weight.CollectionView;
import com.immomo.mlservics.weight.ListView;
import com.immomo.mlservics.weight.ViewGroup;
import com.immomo.mlservics.weight.ViewPager;
import com.immomo.mlservics.weight.WaterFallView;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.GlobalConfigManager;
import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.code.CodeGenerator;
import com.immomo.mmpaas.code.ViewGenerator;
import com.immomo.mmpaas.panel.design.weight.InsertViewBean;
import com.immomo.mmpaas.panel.devicetoolbar.DeviceToolbarPanel;
import com.immomo.mmpaas.panel.devicetoolbar.bean.ScaleMessage;
import com.immomo.mmpaas.panel.message.MessagePanel;
import com.immomo.mmpaas.panel.virtual.view.VirtualPhoneView;
import com.immomo.mmpaas.plugin.FileTypeUtils;
import com.immomo.mmpaas.utils.StringUtils;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.BorderUIResource;

public class PhonePanel
extends BasePanel
implements LuaInstance.StateChangeListener,
BroadCastReceiver {
    public static final int NORTH_HEIGHT = 30;
    private JBSplitter jbSplitter;
    private JPanel panel;
    private String luaFilePath;
    private VirtualFile virtualFile;
    private VirtualPhoneView virtualPhoneView;
    private MessagePanel messagePanel;
    private LuaInstance instance;
    private JComponent luaContainer;
    private boolean needReloader;
    private DeviceToolbarPanel deviceToolbarPanel;
    private boolean isInitCodeGenerator;
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (PhonePanel.this.instance == null || StringUtils.isEmpty(PhonePanel.this.luaFilePath)) {
                return;
            }
            GlobalConfigManager.getInstance().getPreViewConfigBean().setFilePath(PhonePanel.this.luaFilePath);
            PhonePanel.this.forceReload();
        }
    };

    public void setFilePath(String filePath, VirtualFile file) {
        VirtualFile virtualFile;
        String ext = FileTypeUtils.getExtension(file.getName());
        if (FileTypeUtils.isUIExtension(ext)) {
            VirtualFile virtualFile2 = LLuaVirtualFileUtil.getLLuaUIFilePath(filePath);
            if (virtualFile2 == null) {
                return;
            }
            filePath = virtualFile2.getPath();
            file = virtualFile2;
        } else if (FileTypeUtils.isStartUILayout(file) && (virtualFile = LLuaVirtualFileUtil.getLuaPreviewFilePath(filePath)) != null) {
            filePath = virtualFile.getPath();
            file = virtualFile;
        }
        this.luaFilePath = filePath;
        this.virtualFile = file;
        if (this.instance == null || StringUtils.isEmpty(this.luaFilePath)) {
            return;
        }
        this.needReloader = true;
        GlobalConfigManager.getInstance().getPreViewConfigBean().setFilePath(this.luaFilePath);
    }

    public void forceReload() {
        this.needReloader = true;
        this.tryReload(this.luaFilePath);
    }

    public PhonePanel(Context context2, boolean canEdit) {
        super(context2);
        this.setCanEdit(canEdit);
    }

    @Override
    public void build() {
        this.initComponent();
        this.initCheckView();
        this.jbSplitter.setFirstComponent((JComponent)this.panel);
        this.jbSplitter.setSecondComponent(this.messagePanel.getComponent());
    }

    private void initComponent() {
        this.jbSplitter = new JBSplitter(true, 0.85f, 0.5f, 1.0f);
        this.jbSplitter.setDividerWidth(4);
        this.jbSplitter.getDivider().setBackground(this.context.getTheme().borderColor);
        this.jbSplitter.setBackground(this.context.getTheme().transparent);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBackground(this.context.getTheme().transparent);
        this.panel.setBorder(new BorderUIResource.LineBorderUIResource(this.context.getTheme().borderColor));
        this.panel.addComponentListener(this.componentAdapter);
        this.initNorthView();
        this.initCenterView();
        this.initSouthView();
    }

    private void initCheckView() {
        this.context.registerReceiver(this.context, "BC_MAIN_TAB_SELECTED", this);
        this.context.registerReceiver(this.context, "BC_PHOTO_PANEL_REFRESH", this);
        this.context.registerReceiver(this.context, "BC_INSERT_COMPONENT", this);
        this.context.registerReceiver(this.context, "BC_RESET_SCALE_UPDATE", this);
        this.context.registerReceiver(this.context, "BC_PREVIEW_UPDATE", this);
    }

    @Override
    public void destroy() {
        if (this.deviceToolbarPanel != null) {
            this.deviceToolbarPanel.destroy();
        }
        if (this.messagePanel != null) {
            this.messagePanel.destroy();
        }
        this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
        this.context.unregisterReceiver("BC_PHOTO_PANEL_REFRESH", this);
        this.context.unregisterReceiver("BC_INSERT_COMPONENT", this);
        this.context.unregisterReceiver("BC_PHOTO_PANEL_CODE", this);
        this.context.unregisterReceiver("BC_RESET_SCALE_UPDATE", this);
        if (this.panel != null) {
            this.panel.removeComponentListener(this.componentAdapter);
        }
        this.context.unregisterReceiver("BC_PREVIEW_UPDATE", this);
    }

    private void initNorthView() {
        this.deviceToolbarPanel = new DeviceToolbarPanel(this.context);
        this.registerChildLifeCycle(this.deviceToolbarPanel);
        this.deviceToolbarPanel.build();
        this.deviceToolbarPanel.getComponent().setPreferredSize(new Dimension(this.getWidth(), 30));
        this.panel.add((Component)this.deviceToolbarPanel.getComponent(), "North");
    }

    private void initCenterView() {
        this.virtualPhoneView = new VirtualPhoneView(this.context, this.panel);
        this.registerChildLifeCycle(this.virtualPhoneView);
        this.luaContainer = this.virtualPhoneView.getLuaContainer();
        this.instance = new LuaInstance(this.context);
        this.instance.setContainer(this.luaContainer);
        this.instance.setStateChangeListener(this);
    }

    private void initSouthView() {
        this.messagePanel = new MessagePanel(this.context);
        this.registerChildLifeCycle(this.messagePanel);
    }

    @Override
    public JComponent getComponent() {
        return this.jbSplitter;
    }

    @Override
    public void onStateChanged(int type2, int code, Throwable error2) {
        this.panel.revalidate();
        this.panel.repaint();
        if (code == 0) {
            this.context.sendBroadCastMessageAsync(BroadCastMessage.obtain("BC_WINDOW_TREE_UPDATE", this.virtualPhoneView.getLuaContainer()));
            if (!this.isInitCodeGenerator && this.canEdit() && type2 == 2) {
                CodeGenerator.getInstance().init(this.luaFilePath, this.luaContainer);
                this.context.registerReceiver(this.context, "BC_PHOTO_PANEL_CODE", this);
                this.isInitCodeGenerator = true;
            }
        }
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_MAIN_TAB_SELECTED": {
                int type2 = (Integer)msg.msg;
                if (type2 == 1) {
                    if (this.visible) break;
                    this.visible = true;
                    context2.updatePanel(this);
                    break;
                }
                if (type2 != 2 || !this.visible) break;
                this.visible = false;
                context2.updatePanel(this);
                break;
            }
            case "BC_PHOTO_PANEL_REFRESH": {
                this.forceReload();
                break;
            }
            case "BC_PHOTO_PANEL_CODE": {
                this.changeCodeFile();
                break;
            }
            case "BC_INSERT_COMPONENT": {
                InsertViewBean bean = (InsertViewBean)msg.msg;
                IView view = ViewGenerator.getInstance().generateView(bean.getHolder().luaClassName);
                IView targetView = bean.getTargetView();
                if (targetView instanceof LuaWindow) {
                    return false;
                }
                ViewGroup viewGroup = targetView instanceof ViewGroup ? (ViewGroup)targetView : (ViewGroup)((Component)((Object)targetView)).getParent();
                if (!this.isSupportAddView(viewGroup)) {
                    return false;
                }
                viewGroup.add(view, -1);
                viewGroup.requestLayout();
                context2.sendBroadCastMessageAsync(BroadCastMessage.obtain("BC_WINDOW_TREE_UPDATE", this.virtualPhoneView.getLuaContainer()));
                BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK", view));
                BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_DROP_EXIT", view));
                break;
            }
            case "BC_RESET_SCALE_UPDATE": {
                ScaleMessage message2 = (ScaleMessage)msg.msg;
                if (message2.getScaleSize() < this.virtualPhoneView.getSizeScale() && this.virtualPhoneView.isMatchParent()) break;
                this.virtualPhoneView.setSizeScale(message2.getScaleSize());
                this.virtualPhoneView.setMatchParent(false);
                this.forceReload();
                break;
            }
            case "BC_PREVIEW_UPDATE": {
                VirtualFile lluaFile = (VirtualFile)msg.msg;
                if (lluaFile == null) break;
                this.setFilePath(lluaFile.getPath(), lluaFile);
            }
        }
        return false;
    }

    private void changeCodeFile() {
        if (Application.getApp().isPlugin()) {
            ApplicationManager.getApplication().invokeLater(() -> CodeGenerator.getInstance().changeCodeFileByPlugin(this.instance.getLuaWindow(), this.virtualFile));
        } else {
            SwingUtilities.invokeLater(() -> CodeGenerator.getInstance().changeCodeFile(this.instance.getLuaWindow(), this.luaFilePath));
        }
    }

    private void tryReload(String path) {
        if (path == null) {
            return;
        }
        this.virtualPhoneView.processLuaContainerBounds();
        this.virtualPhoneView.resetPhoneBounds();
        if (this.needReloader) {
            this.instance.reload(path);
            this.needReloader = false;
        }
        BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHONE_TOUCH_CLICK_EXIT", null));
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_HIERARCHY_EXIT"));
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_PROPERTY_DISPLAY"));
    }

    public boolean isSupportAddView(ViewGroup viewGroup) {
        return !(viewGroup instanceof ViewPager) && !(viewGroup instanceof CollectionView) && !(viewGroup instanceof ListView) && !(viewGroup instanceof WaterFallView);
    }
}

