/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view.listener;

import com.immomo.mmpaas.panel.property_panel.model.item.StringItem;
import com.immomo.mmpaas.utils.StringUtils;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class StringItemDocumentUpdater
implements DocumentListener {
    private StringItem item;

    public StringItemDocumentUpdater() {
    }

    public StringItemDocumentUpdater(StringItem item) {
        this.item = item;
    }

    public void setItem(StringItem item) {
        this.item = item;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.canUpdateWithEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.canUpdateWithEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.canUpdateWithEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    private String getText(DocumentEvent e) {
        try {
            Document document = e.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private boolean canUpdateWithEmptyContent(String content) {
        if (StringUtils.isEmpty(content) || StringUtils.isBlank(content)) {
            this.item.updateWithContent("");
            return true;
        }
        return false;
    }
}

