/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view.custom;

import com.immomo.mmpaas.panel.property_panel.interfaces.TableViewDataSource;
import com.immomo.mmpaas.panel.property_panel.view.custom.SimpleLinearLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;

public class TableView
extends SimpleLinearLayout {
    private TableViewDataSource dataSource;
    private Map<Integer, JComponent> sectionContentViewMap;

    public TableView(TableViewDataSource dataSource) {
        this(SimpleLinearLayout.Orientation.VERTICAL, dataSource);
    }

    private TableView(SimpleLinearLayout.Orientation orientation, TableViewDataSource dataSource) {
        super(orientation);
        this.setOpaque(true);
        this.setDataSource(dataSource);
    }

    public void setDataSource(TableViewDataSource dataSource) {
        this.dataSource = dataSource;
        this.onPaint();
    }

    public TableViewDataSource getDataSource() {
        return this.dataSource;
    }

    public JComponent getSectionContentView(int section) {
        return this.sectionContentViewMap.get(section);
    }

    private void onPaint() {
        if (this.dataSource == null) {
            return;
        }
        this.sectionContentViewMap = new HashMap<Integer, JComponent>();
        int sectionCount = this.dataSource.numberOfSections();
        for (int si = 0; si < sectionCount; ++si) {
            this.drawHeaderView(si);
            this.drawCells(si);
            this.drawFooterView(si);
        }
    }

    private void drawCells(int si) {
        Box bodyView = Box.createVerticalBox();
        bodyView.setOpaque(false);
        this.sectionContentViewMap.put(si, bodyView);
        int rowCount = this.dataSource.numberOfRowsInSection(si);
        for (int ri = 0; ri < rowCount; ++ri) {
            JComponent cell = this.dataSource.cellForRowAtIndexPath(ri, si);
            bodyView.add(cell);
            Component cellSeparator = Box.createVerticalStrut(this.dataSource.heightForSeparator());
            bodyView.add(cellSeparator);
        }
        this.add(bodyView);
    }

    private void drawHeaderView(int si) {
        JComponent headerView = this.dataSource.headerViewForSection(si);
        if (headerView == null) {
            return;
        }
        SimpleLinearLayout headerViewContainer = new SimpleLinearLayout(SimpleLinearLayout.Orientation.HORIZONTAL);
        ((Container)((Object)headerViewContainer)).add(headerView);
        this.add((Component)((Object)headerViewContainer));
    }

    private void drawFooterView(int si) {
        JComponent footerView = this.dataSource.footerViewForSection(si);
        if (footerView == null) {
            return;
        }
        this.add(footerView);
    }
}

