/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view.custom;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class CusButton
extends JLabel {
    private Icon selectedImage;
    private Icon defaultImage;
    private boolean isSelected = false;
    private ButtonClickedListener listener;

    public CusButton(String title) {
        super(title);
        this.setClickedListener();
    }

    public CusButton(String title, Icon defaultImage, int alignment) {
        super(title, defaultImage, alignment);
        this.setDefaultImage(defaultImage);
        this.setClickedListener();
    }

    public void setDefaultImage(Icon defaultImage) {
        this.defaultImage = defaultImage;
        this.setIcon(defaultImage);
    }

    public void setSelectedImage(Icon selectedImage) {
        this.selectedImage = selectedImage;
    }

    public void setButtonClickedListener(ButtonClickedListener listener) {
        if (listener == null) {
            return;
        }
        this.listener = listener;
    }

    private void setClickedListener() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CusButton.this.selectedImage == null || CusButton.this.defaultImage == null) {
                    return;
                }
                CusButton.this.isSelected = !CusButton.this.isSelected;
                CusButton.this.setIcon(CusButton.this.isSelected ? CusButton.this.selectedImage : CusButton.this.defaultImage);
                if (CusButton.this.listener != null) {
                    CusButton.this.listener.buttonClicked();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public static interface ButtonClickedListener {
        public void buttonClicked();
    }
}

