/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class StringItemView
extends ItemView {
    private JTextField textField;
    private String desc;
    private String content;

    public StringItemView(Item item, ActionListener actionListener) {
        super(item, null);
        this.desc = item.realDesc();
        this.content = item.getContents()[0];
        this.initLeftRightView();
        this.wireActionListener(actionListener);
    }

    public StringItemView(Item item, DocumentListener listener) {
        super(item, null);
        this.desc = item.realDesc();
        this.content = item.getContents()[0];
        this.initLeftRightView();
        this.wireListener(listener);
    }

    @Override
    public JComponent registerLeftView() {
        return this.getPropertyDesView(this.desc);
    }

    @Override
    public JComponent registerRightView() {
        this.textField = this.getPropertyInputView();
        this.textField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str, a);
            }
        });
        this.textField.setText(this.content);
        this.textField.setCaretPosition(0);
        return this.textField;
    }

    @Override
    public JComponent registerTopLeftView() {
        return null;
    }

    @Override
    public JComponent registerTopRightView() {
        return null;
    }

    @Override
    public JComponent registerBottomLeftView() {
        return null;
    }

    @Override
    public JComponent registerBottomRightView() {
        return null;
    }

    private void wireListener(DocumentListener listener) {
        Document document = this.textField.getDocument();
        if (listener != null) {
            document.addDocumentListener(listener);
        }
    }

    private void wireActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.textField.addActionListener(listener);
    }

    @Override
    protected void refreshUI() {
        this.textField.setText(this.content);
    }

    @Override
    protected String refreshDataSource() {
        this.content = this.item.getContents()[0];
        return this.content;
    }
}

