/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.utils.StringUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SizeItemView
extends ItemView {
    private static final String WRAP_CONTENT = "WRAP_CONTENT";
    private static final String MATCH_PARENT = "MATCH_PARENT";
    private JComboBox comboBox;
    private String desc;
    private String content;

    public SizeItemView(Item item, ItemListener listener) {
        super(item, listener);
        this.desc = item.desc;
        this.content = item.getContents()[0];
        this.initLeftRightView();
        this.wireListener(listener);
    }

    @Override
    public JComponent registerLeftView() {
        return this.getPropertyDesView(this.desc);
    }

    @Override
    public JComponent registerRightView() {
        this.comboBox = this.getPropertyDropDownView(true);
        this.comboBox.addItem(WRAP_CONTENT);
        this.comboBox.addItem(MATCH_PARENT);
        this.comboBox.setSelectedItem(this.content);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !SizeItemView.isNumber(SizeItemView.this.comboBox.getEditor().getItem().toString()) && SizeItemView.notWrapContentOrMatchParent(SizeItemView.this.comboBox.getEditor().getItem().toString())) {
                    SizeItemView.this.comboBox.getEditor().setItem("0");
                }
            }
        });
        return this.comboBox;
    }

    @Override
    public JComponent registerTopLeftView() {
        return null;
    }

    @Override
    public JComponent registerTopRightView() {
        return null;
    }

    @Override
    public JComponent registerBottomLeftView() {
        return null;
    }

    @Override
    public JComponent registerBottomRightView() {
        return null;
    }

    @Override
    protected void refreshUI() {
        if (StringUtils.isBlank(this.content)) {
            return;
        }
        this.comboBox.setSelectedItem(this.content);
    }

    @Override
    protected String refreshDataSource() {
        this.content = this.item.getContents()[0];
        return this.content;
    }

    private void wireListener(ItemListener listener) {
        if (listener != null) {
            this.comboBox.addItemListener(listener);
        }
    }

    protected static boolean notWrapContentOrMatchParent(String str) {
        return !WRAP_CONTENT.equals(str) && !MATCH_PARENT.equals(str);
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

