/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.model.item.SelectionItem;
import com.immomo.mmpaas.panel.property_panel.view.GroupItemView;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.panel.property_panel.view.ItemViewBuilder;
import com.immomo.mmpaas.panel.property_panel.view.custom.CusButton;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SelectionItemView
extends ItemView {
    private Map<String, ItemView> map = new HashMap<String, ItemView>();
    private JComboBox optionMenu;
    private SelectionItem selectionItem;
    private Box wholePanel;
    private String title;

    public SelectionItemView(Item item, ItemListener listener) {
        super(item, null);
        this.selectionItem = (SelectionItem)item;
        this.title = item.desc;
        this.initTopBottomView();
        this.configContentViewForOptionMenu();
        this.addItemListenerForOptionMenu();
        this.configItemForOptionMenu();
        this.setSelectedItemForOptionMenu();
    }

    private void configContentViewForOptionMenu() {
        for (Item childItem : this.selectionItem.childItems) {
            ItemView itemView = ItemViewBuilder.buildWithItem(childItem);
            if (itemView instanceof GroupItemView) {
                itemView.setTopViewGone();
            }
            this.addView(itemView, childItem.realDesc());
        }
    }

    private void addView(ItemView itemView, String desc) {
        if (this.map.containsKey(desc)) {
            return;
        }
        this.map.put(desc, itemView);
        this.wholePanel.add(itemView.getPanel());
        this.wholePanel.add(Box.createVerticalStrut(10));
        this.optionMenu.addItem(desc);
    }

    private void setSelectedItemForOptionMenu() {
        this.setItemForOptionMenu(this.selectionItem.getSelectedItem());
    }

    private void configItemForOptionMenu() {
        for (Item childItem : this.selectionItem.childItems) {
            this.setItemForOptionMenu(childItem.realDesc());
        }
    }

    private void addItemListenerForOptionMenu() {
        this.optionMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                for (Map.Entry entry : SelectionItemView.this.map.entrySet()) {
                    if (((String)entry.getKey()).equals(e.getItem().toString())) {
                        ((ItemView)entry.getValue()).refresh();
                        ((ItemView)entry.getValue()).getPanel().setVisible(true);
                        continue;
                    }
                    ((ItemView)entry.getValue()).getPanel().setVisible(false);
                }
            }
        });
    }

    private void setItemForOptionMenu(String desc) {
        this.optionMenu.setSelectedItem(desc);
    }

    @Override
    public JComponent registerLeftView() {
        return null;
    }

    @Override
    public JComponent registerRightView() {
        return null;
    }

    @Override
    public JComponent registerTopLeftView() {
        this.descLabel = new CusButton(this.item.desc, ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_down), 0);
        this.descLabel.setSelectedImage(ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_right));
        this.descLabel.setFont(new Font(null, 0, Theme.dark.propertyDesSize));
        this.descLabel.setOpaque(false);
        this.descLabel.setForeground(Theme.dark.propertyTextColor);
        this.descLabel.setPreferredSize(new Dimension(75, 25));
        this.descLabel.setMinimumSize(this.descLabel.getPreferredSize());
        this.descLabel.setVerticalAlignment(0);
        this.descLabel.setHorizontalAlignment(4);
        this.descLabel.setSelectedImage(ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_right));
        this.descLabel.setButtonClickedListener(new CusButton.ButtonClickedListener(){

            @Override
            public void buttonClicked() {
                SelectionItemView.this.wholePanel.setVisible(!SelectionItemView.this.wholePanel.isVisible());
                SelectionItemView.this.optionMenu.setVisible(!SelectionItemView.this.optionMenu.isVisible());
            }
        });
        return this.descLabel;
    }

    @Override
    public JComponent registerTopRightView() {
        this.optionMenu = this.getPropertyDropDownView(false);
        return this.optionMenu;
    }

    @Override
    public JComponent registerBottomLeftView() {
        return null;
    }

    @Override
    public JComponent registerBottomRightView() {
        this.wholePanel = Box.createVerticalBox();
        return this.wholePanel;
    }

    @Override
    protected void refreshUI() {
    }

    @Override
    protected String refreshDataSource() {
        return null;
    }
}

