/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.utils.StringUtils;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberItemView
extends ItemView {
    protected JTextField textField;
    private String desc;
    private String content;
    private final DocumentListener documentListener;
    private double maxLimit = Double.MAX_VALUE;
    private double minLimit = -1.7976931348623157E308;

    public NumberItemView(Item item, DocumentListener listener) {
        super(item, null);
        this.desc = item.desc;
        this.content = item.getContents()[0];
        this.documentListener = listener;
        this.initLeftRightView();
        this.wireListener(listener);
    }

    public void setMaxLimit(double doubleMax) {
        this.maxLimit = doubleMax;
    }

    public void setMinLimit(double doubleMin) {
        this.minLimit = doubleMin;
    }

    @Override
    public JComponent registerLeftView() {
        return this.getPropertyDesView(this.desc);
    }

    @Override
    public JComponent registerRightView() {
        this.textField = this.getPropertyInputView();
        this.setDocument();
        this.textField.setText(this.content);
        this.textField.setCaretPosition(0);
        return this.textField;
    }

    @Override
    public JComponent registerTopLeftView() {
        return null;
    }

    @Override
    public JComponent registerTopRightView() {
        return null;
    }

    @Override
    public JComponent registerBottomLeftView() {
        return null;
    }

    @Override
    public JComponent registerBottomRightView() {
        return null;
    }

    private void wireListener(DocumentListener listener) {
        Document document = this.textField.getDocument();
        if (listener != null) {
            document.addDocumentListener(listener);
        }
    }

    protected void setDocument() {
        this.textField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (!NumberItemView.isNumber(NumberItemView.this.textField.getText() + str)) {
                    return;
                }
                if (NumberItemView.this.isOverflow(str)) {
                    return;
                }
                super.insertString(offs, str, a);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isOverflow(String str) {
        if (Double.parseDouble(this.textField.getText() + str) > this.maxLimit) return true;
        StringBuilder stringBuilder = new StringBuilder();
        if (!(Double.parseDouble(stringBuilder.append(this.textField.getText()).append(str).toString()) < this.minLimit)) return false;
        return true;
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected void refreshUI() {
        if (StringUtils.isBlank(this.content)) {
            return;
        }
        if (this.documentListener != null) {
            this.textField.getDocument().removeDocumentListener(this.documentListener);
        }
        this.textField.setText(this.content);
        if (this.documentListener != null) {
            this.textField.getDocument().addDocumentListener(this.documentListener);
        }
    }

    @Override
    protected String refreshDataSource() {
        this.content = this.item.getContents()[0];
        return this.content;
    }
}

