/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.BoolItem;
import com.immomo.mmpaas.panel.property_panel.model.item.ColorItem;
import com.immomo.mmpaas.panel.property_panel.model.item.EnumItem;
import com.immomo.mmpaas.panel.property_panel.model.item.GroupItem;
import com.immomo.mmpaas.panel.property_panel.model.item.IntegerItem;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.model.item.NumberItem;
import com.immomo.mmpaas.panel.property_panel.model.item.SelectionItem;
import com.immomo.mmpaas.panel.property_panel.model.item.StringItem;
import com.immomo.mmpaas.panel.property_panel.view.BoolItemView;
import com.immomo.mmpaas.panel.property_panel.view.ColorItemView;
import com.immomo.mmpaas.panel.property_panel.view.EnumItemView;
import com.immomo.mmpaas.panel.property_panel.view.GroupItemView;
import com.immomo.mmpaas.panel.property_panel.view.IntegerItemView;
import com.immomo.mmpaas.panel.property_panel.view.ItemUpdater;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.panel.property_panel.view.NumberItemView;
import com.immomo.mmpaas.panel.property_panel.view.SelectionItemView;
import com.immomo.mmpaas.panel.property_panel.view.SizeItemView;
import com.immomo.mmpaas.panel.property_panel.view.StringItemView;
import com.immomo.mmpaas.panel.property_panel.view.listener.StringItemDocumentUpdater;
import com.immomo.mmpaas.panel.property_panel.view.listener.StringItemEventsUpdater;

public class ItemViewBuilder {
    public static ItemView buildWithItem(Item item) {
        ItemUpdater listener = new ItemUpdater(item);
        if (item instanceof SelectionItem) {
            SelectionItemView selectionItemView = new SelectionItemView(item, listener);
            return selectionItemView;
        }
        if (item instanceof GroupItem) {
            GroupItemView itemView = new GroupItemView(item, listener);
            return itemView;
        }
        if (item instanceof EnumItem) {
            EnumItemView itemView = new EnumItemView(item, ((EnumItem)item).getEnumMenuItems(), listener);
            return itemView;
        }
        if (item instanceof BoolItem) {
            BoolItemView itemView = new BoolItemView(item, listener);
            return itemView;
        }
        if (item instanceof ColorItem) {
            ColorItemView itemView = new ColorItemView(item, listener);
            return itemView;
        }
        if (item instanceof IntegerItem) {
            if (ItemViewBuilder.showSizeView(item.desc)) {
                SizeItemView itemView = new SizeItemView(item, listener);
                return itemView;
            }
            IntegerItemView itemView = new IntegerItemView(item, listener);
            return itemView;
        }
        if (item instanceof NumberItem) {
            if (ItemViewBuilder.showSizeView(item.desc)) {
                SizeItemView itemView = new SizeItemView(item, listener);
                return itemView;
            }
            NumberItemView itemView = new NumberItemView(item, listener);
            itemView.setMaxLimit(item.myAnnotation.maxLimit());
            itemView.setMinLimit(item.myAnnotation.minLimit());
            return itemView;
        }
        if (item instanceof StringItem) {
            StringItemView itemView;
            StringItem stringItem = (StringItem)item;
            if (item.myAnnotation.needActionUpdater()) {
                StringItemEventsUpdater updater = new StringItemEventsUpdater(stringItem);
                itemView = new StringItemView((Item)stringItem, updater);
            } else {
                StringItemDocumentUpdater updater = new StringItemDocumentUpdater(stringItem);
                itemView = new StringItemView((Item)stringItem, updater);
            }
            return itemView;
        }
        return null;
    }

    private static boolean showSizeView(String desc) {
        return "\u5bbd\u5ea6".equals(desc) || "\u9ad8\u5ea6".equals(desc);
    }
}

