/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.property_panel.interfaces.IPropertyItemView;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.custom.CusButton;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public abstract class ItemView
implements IPropertyItemView {
    public static final int leftWidth = 75;
    protected static final int height = 25;
    public static final int MARGIN_TOP = 10;
    protected static final int LEFT_RIGHT_MARGIN = 10;
    protected final Theme theme;
    protected Box panel;
    JSplitPane jSplitPanel;
    protected ItemListener listener;
    protected Item item;
    private JComponent topView;
    protected CusButton descLabel;
    protected static final int DESC_ALIGNMENT = 4;
    protected static final int DESC_WIDTH = 75;

    public ItemView(Item item, ItemListener listener) {
        this.listener = listener;
        this.item = item;
        this.theme = Application.getApplicationContext().getTheme();
        this.panel = Box.createHorizontalBox();
    }

    @Override
    public void initLeftRightView() {
        JComponent rightView;
        this.jSplitPanel = new JSplitPane();
        this.jSplitPanel.setOpaque(false);
        this.jSplitPanel.setDividerSize(0);
        this.jSplitPanel.setBorder(null);
        BasicSplitPaneDivider divider = (BasicSplitPaneDivider)this.jSplitPanel.getComponent(2);
        divider.setBackground(Theme.dark.transparent);
        divider.setBorder(null);
        JComponent leftView = this.registerLeftView();
        if (leftView != null) {
            this.jSplitPanel.setLeftComponent(leftView);
        }
        if ((rightView = this.registerRightView()) != null) {
            Box rightContainer = Box.createHorizontalBox();
            rightContainer.add(Box.createHorizontalStrut(10));
            rightContainer.add(rightView);
            this.jSplitPanel.setRightComponent(rightContainer);
        }
        if (rightView != null || leftView != null) {
            this.panel.add(this.jSplitPanel);
        }
    }

    public void setTopViewGone() {
        if (this.topView != null) {
            this.topView.setPreferredSize(new Dimension(0, 0));
            this.topView.setVisible(false);
        }
    }

    @Override
    public void initTopBottomView() {
        Box topBottomContainer = Box.createVerticalBox();
        this.topView = this.getTopView();
        if (this.topView != null) {
            topBottomContainer.add(this.topView);
        }
        topBottomContainer.add(Box.createVerticalStrut(5));
        JComponent bottomView = this.getBottomView();
        if (bottomView != null) {
            topBottomContainer.add(bottomView);
        }
        if (this.topView != null || bottomView != null) {
            this.panel.add(topBottomContainer);
        }
    }

    protected int getDescWidth(String content) {
        JLabel jLabel = this.getPropertyDesView("");
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        return fontMetrics.charsWidth(content.toCharArray(), 0, content.length());
    }

    protected JComponent getTopView() {
        JComponent topLeftView = this.registerTopLeftView();
        JComponent topRightView = this.registerTopRightView();
        if (topLeftView != null && topRightView != null) {
            Box box = Box.createHorizontalBox();
            JSplitPane jSplitPanel = new JSplitPane();
            jSplitPanel.setOpaque(false);
            jSplitPanel.setDividerLocation(75);
            jSplitPanel.setDividerSize(0);
            jSplitPanel.setBorder(null);
            BasicSplitPaneDivider divider = (BasicSplitPaneDivider)jSplitPanel.getComponent(2);
            divider.setBackground(Theme.dark.transparent);
            divider.setBorder(null);
            jSplitPanel.setLeftComponent(this.registerTopLeftView());
            Box rightContainer = Box.createHorizontalBox();
            rightContainer.add(Box.createHorizontalStrut(10));
            rightContainer.add(topRightView);
            jSplitPanel.setRightComponent(rightContainer);
            box.add(jSplitPanel);
            return box;
        }
        return null;
    }

    private JComponent getBottomView() {
        JComponent bottomLeftView = this.registerBottomLeftView();
        JComponent bottomRightView = this.registerBottomRightView();
        if (bottomLeftView != null && bottomRightView != null) {
            Box box = Box.createHorizontalBox();
            JSplitPane jSplitPanel = new JSplitPane();
            jSplitPanel.setOpaque(false);
            jSplitPanel.setDividerLocation(75);
            jSplitPanel.setDividerSize(0);
            jSplitPanel.setBorder(null);
            BasicSplitPaneDivider divider = (BasicSplitPaneDivider)jSplitPanel.getComponent(2);
            divider.setBackground(Theme.dark.transparent);
            divider.setBorder(null);
            jSplitPanel.setLeftComponent(bottomLeftView);
            Box rightContainer = Box.createHorizontalBox();
            rightContainer.add(Box.createHorizontalStrut(10));
            rightContainer.add(bottomRightView);
            jSplitPanel.setRightComponent(rightContainer);
            box.add(jSplitPanel);
            return box;
        }
        if (bottomLeftView != null || bottomRightView != null) {
            Box box = Box.createHorizontalBox();
            box.add(bottomLeftView != null ? bottomLeftView : bottomRightView);
            return box;
        }
        return null;
    }

    public Container getPanel() {
        return this.panel;
    }

    public abstract JComponent registerLeftView();

    public abstract JComponent registerRightView();

    public abstract JComponent registerTopLeftView();

    public abstract JComponent registerTopRightView();

    public abstract JComponent registerBottomLeftView();

    public abstract JComponent registerBottomRightView();

    @Override
    public JLabel getPropertyDesView(String desc) {
        this.descLabel = new CusButton(desc);
        this.descLabel.setFont(new Font(null, 0, Theme.dark.propertyDesSize));
        this.descLabel.setOpaque(false);
        this.descLabel.setForeground(Theme.dark.propertyTextColor);
        this.descLabel.setVerticalAlignment(0);
        this.descLabel.setHorizontalAlignment(4);
        this.descLabel.setPreferredSize(new Dimension(75, 25));
        this.descLabel.setMinimumSize(this.descLabel.getPreferredSize());
        return this.descLabel;
    }

    @Override
    public JTextField getPropertyInputView() {
        JTextField textField = new JTextField();
        textField.setBackground(this.theme.propertyInputBackground);
        textField.setForeground(this.theme.propertyInputColor);
        textField.setFont(new Font(null, 0, this.theme.propertyInputSize));
        textField.setPreferredSize(new Dimension(80, 25));
        textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        textField.setBorder(BorderFactory.createLineBorder(this.theme.propertyBorderColor, 1, true));
        return textField;
    }

    @Override
    public JComboBox getPropertyDropDownView(boolean isEditable) {
        JComboBox optionMenu = new JComboBox();
        optionMenu.setPreferredSize(new Dimension(80, 25));
        optionMenu.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        optionMenu.setFont(new Font(null, 0, this.theme.propertyInputSize));
        optionMenu.setBackground(this.theme.propertyInputBackground);
        optionMenu.setForeground(this.theme.propertyTextColor);
        optionMenu.setUI(new BasicComboBoxUI(){

            @Override
            protected ComboBoxEditor createEditor() {
                return super.createEditor();
            }

            @Override
            protected JButton createArrowButton() {
                JButton jButton = new JButton();
                jButton.setIcon(ImageLoader.getInstance().loadProjectImageIcon(P.icons.drop_down));
                jButton.setBackground(Color.WHITE);
                jButton.setOpaque(true);
                jButton.setContentAreaFilled(false);
                jButton.setBorder(null);
                return jButton;
            }

            @Override
            protected Insets getInsets() {
                return JBUI.emptyInsets();
            }
        });
        optionMenu.getEditor().getEditorComponent().setBackground(this.theme.propertyInputBackground);
        optionMenu.getEditor().getEditorComponent().setForeground(this.theme.propertyTextColor);
        optionMenu.setEditable(isEditable);
        return optionMenu;
    }

    @Override
    public JPanel getColorView() {
        JPanel colorView = new JPanel();
        colorView.setPreferredSize(new Dimension(30, 10));
        colorView.setMaximumSize(new Dimension(30, 10));
        colorView.setOpaque(true);
        colorView.setBorder(null);
        return colorView;
    }

    @Override
    public JCheckBox getPropertyCheckView(boolean isCheck) {
        JCheckBox boolItem = new JCheckBox(String.valueOf(isCheck), isCheck);
        boolItem.setPreferredSize(new Dimension(20, 25));
        boolItem.setForeground(this.theme.propertyTextColor);
        return boolItem;
    }

    @Override
    public JFormattedTextField getPropertyColorInputView() {
        JFormattedTextField textField = new JFormattedTextField();
        textField.setBackground(this.theme.propertyInputBackground);
        textField.setForeground(this.theme.propertyInputColor);
        textField.setFont(new Font(null, 0, this.theme.propertyInputSize));
        textField.setPreferredSize(new Dimension(80, 25));
        textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        textField.setBorder(BorderFactory.createLineBorder(this.theme.propertyBorderColor, 1, true));
        return textField;
    }

    protected void refresh() {
        this.refreshDataSource();
        this.refreshUI();
    }

    protected abstract void refreshUI();

    protected abstract String refreshDataSource();
}

