/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.BoolItem;
import com.immomo.mmpaas.panel.property_panel.model.item.EnumItem;
import com.immomo.mmpaas.panel.property_panel.model.item.IntegerItem;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.model.item.NumberItem;
import com.immomo.mmpaas.panel.property_panel.model.item.StringItem;
import com.immomo.mmpaas.panel.property_panel.view.SizeItemView;
import com.immomo.mmpaas.utils.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ItemUpdater
implements DocumentListener,
ItemListener,
ActionListener {
    private Item item;
    private String contentForEnterEvent = "";

    public ItemUpdater() {
    }

    public ItemUpdater(Item item) {
        this.item = item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.item.updateWithContent(e.getActionCommand());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.adaptForEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.adaptForEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.adaptForEmptyContent(this.getText(e))) {
            return;
        }
        this.item.updateWithContent(this.getText(e));
    }

    private String getText(DocumentEvent e) {
        try {
            Document document = e.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.item instanceof EnumItem && e.getStateChange() == 1) {
            this.item.updateWithContent(e.getItem().toString());
        } else if (this.item instanceof BoolItem) {
            JCheckBox checkBox = (JCheckBox)e.getItem();
            String boolInfo = Boolean.toString(checkBox.isSelected());
            checkBox.setText(boolInfo);
            this.item.updateWithContent(boolInfo);
        } else if (this.item instanceof NumberItem && e.getStateChange() == 1 && e.getStateChange() == 1) {
            if (!SizeItemView.isNumber(e.getItem().toString()) && SizeItemView.notWrapContentOrMatchParent(e.getItem().toString())) {
                return;
            }
            this.item.updateWithContent(e.getItem().toString());
        }
    }

    private boolean adaptForEmptyContent(String content) {
        if (StringUtils.isEmpty(content) || StringUtils.isBlank(content)) {
            if (this.item instanceof StringItem) {
                this.item.updateWithContent("");
            }
            if (this.item instanceof NumberItem || this.item instanceof IntegerItem) {
                this.item.updateWithContent("0");
            }
            return true;
        }
        return false;
    }
}

