/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.panel.property_panel.model.item.GroupItem;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.ItemUpdater;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.panel.property_panel.view.ItemViewBuilder;
import com.immomo.mmpaas.panel.property_panel.view.custom.CusButton;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;

public class GroupItemView
extends ItemView {
    private GroupItem groupItem;
    private CusButton TopLeftView;
    private JLabel TopRightView;
    private List<ItemView> itemViews;
    private Box groupPanel;

    public GroupItemView(Item item, ItemUpdater listener) {
        super(item, listener);
        this.groupItem = (GroupItem)item;
        this.initTopBottomView();
    }

    @Override
    public JComponent registerLeftView() {
        return null;
    }

    @Override
    public JComponent registerRightView() {
        return null;
    }

    @Override
    public JComponent registerTopLeftView() {
        this.TopLeftView = (CusButton)this.getPropertyDesView(this.groupItem.desc);
        this.TopLeftView.setDefaultImage(ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_down));
        this.TopLeftView.setSelectedImage(ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_right));
        this.TopLeftView.setButtonClickedListener(new CusButton.ButtonClickedListener(){

            @Override
            public void buttonClicked() {
                GroupItemView.this.groupPanel.setVisible(!GroupItemView.this.groupPanel.isVisible());
                this.repaint();
            }

            protected void repaint() {
                JRootPane p = GroupItemView.this.groupPanel.getRootPane();
                p.invalidate();
                p.validate();
                p.repaint();
            }
        });
        return this.TopLeftView;
    }

    @Override
    public JComponent registerTopRightView() {
        this.TopRightView = this.getPropertyDesView("");
        return this.TopRightView;
    }

    @Override
    public JComponent registerBottomLeftView() {
        JLabel propertyDesView = this.getPropertyDesView("");
        propertyDesView.setPreferredSize(new Dimension(75, 0));
        propertyDesView.setMinimumSize(new Dimension(75, 0));
        return propertyDesView;
    }

    @Override
    public JComponent registerBottomRightView() {
        Item childItem;
        int i;
        this.groupPanel = Box.createVerticalBox();
        List<Item> childItems = this.groupItem.childItems;
        this.itemViews = new ArrayList<ItemView>();
        int maxDesc = 0;
        for (i = 0; i < childItems.size(); ++i) {
            childItem = childItems.get(i);
            maxDesc = Math.max(maxDesc, this.getDescWidth(childItem.desc));
        }
        for (i = 0; i < childItems.size(); ++i) {
            childItem = childItems.get(i);
            ItemView itemView = ItemViewBuilder.buildWithItem(childItem);
            Dimension preferredSize = new Dimension(maxDesc, 25);
            itemView.descLabel.setPreferredSize(preferredSize);
            itemView.descLabel.setMinimumSize(preferredSize);
            itemView.descLabel.setHorizontalAlignment(2);
            this.groupPanel.add(itemView.getPanel());
            this.itemViews.add(itemView);
            this.groupPanel.add(Box.createVerticalStrut(10));
        }
        return this.groupPanel;
    }

    @Override
    protected void refresh() {
        for (int i = 0; i < this.itemViews.size(); ++i) {
            ItemView itemView = this.itemViews.get(i);
            itemView.refresh();
        }
    }

    @Override
    protected void refreshUI() {
    }

    @Override
    protected String refreshDataSource() {
        return null;
    }
}

