/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.view;

import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.colorChoose.utils.ColorUtil;
import com.immomo.mmpaas.main.ColorChooserDialog;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.utils.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ColorItemView
extends ItemView
implements DocumentListener {
    public static final String DEFAULT_COLOR = "#ffffff";
    private final Dimension screensize;
    private final DocumentListener documentListener;
    private JFormattedTextField textField;
    private JPanel colorView;
    private ColorChooserDialog colorChooserDialog;
    private String desc;
    private String content;

    public ColorItemView(Item item, DocumentListener listener) {
        super(item, null);
        this.desc = item.realDesc();
        this.content = item.getContents()[0];
        this.documentListener = listener;
        this.initLeftRightView();
        this.screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.wireListener(listener);
    }

    @Override
    public JComponent registerLeftView() {
        return this.getPropertyDesView(this.desc);
    }

    @Override
    public JComponent registerRightView() {
        Box colorPanel = Box.createHorizontalBox();
        colorPanel.setBackground(Theme.dark.propertyInputBackground);
        colorPanel.setOpaque(true);
        colorPanel.setPreferredSize(new Dimension(100, 25));
        colorPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.colorView = this.getColorView();
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(5));
        box.add(this.colorView);
        box.add(Box.createVerticalStrut(5));
        this.colorView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ColorItemView.this.colorChooserDialog == null) {
                    ColorItemView.this.colorChooserDialog = new ColorChooserDialog();
                    ColorItemView.this.colorChooserDialog.setColorChangeLisntener(color -> ColorItemView.this.textField.setText(ColorUtil.toHexString(ColorItemView.this.colorChooserDialog.getColor(), true)));
                }
                ColorItemView.this.colorChooserDialog.showX(e, ColorItemView.this.screensize, 18);
            }
        });
        this.textField = this.getPropertyColorInputView();
        this.textField.setBorder(BorderFactory.createLineBorder(this.theme.propertyBorderColor, 0, true));
        this.textField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str, a);
            }
        });
        if (!StringUtils.isEmpty(this.content) && !StringUtils.isBlank(this.content)) {
            this.colorView.setBackground(ColorUtil.toColorInt(this.content));
            this.textField.setText(this.content);
        }
        colorPanel.add(Box.createHorizontalStrut(5));
        colorPanel.add(this.colorView);
        colorPanel.add(Box.createHorizontalStrut(3));
        colorPanel.add(this.textField);
        return colorPanel;
    }

    @Override
    public JComponent registerTopLeftView() {
        return null;
    }

    @Override
    public JComponent registerTopRightView() {
        return null;
    }

    @Override
    public JComponent registerBottomLeftView() {
        return null;
    }

    @Override
    public JComponent registerBottomRightView() {
        return null;
    }

    private void wireListener(DocumentListener listener) {
        Document document = this.textField.getDocument();
        if (listener != null) {
            document.addDocumentListener(listener);
        }
        document.addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String colorS = this.getText(e);
        if (this.checkColor(colorS)) {
            return;
        }
        this.colorView.setBackground(ColorUtil.toColorInt(colorS));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        String colorS = this.getText(e);
        if (this.checkColor(colorS)) {
            return;
        }
        this.colorView.setBackground(ColorUtil.toColorInt(colorS));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        String colorS = this.getText(e);
        if (this.checkColor(colorS)) {
            return;
        }
        this.colorView.setBackground(ColorUtil.toColorInt(colorS));
    }

    private boolean checkColor(String colorS) {
        if (!ColorUtil.isEnableColor(colorS)) {
            this.textField.setBorder(new BorderUIResource.LineBorderUIResource(Color.RED, 1));
            return true;
        }
        this.textField.setBorder(new BorderUIResource.LineBorderUIResource(this.theme.borderColor, 1));
        return false;
    }

    private String getText(DocumentEvent e) {
        try {
            Document document = e.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    protected void refreshUI() {
        if (this.documentListener != null) {
            this.textField.getDocument().removeDocumentListener(this.documentListener);
        }
        if (StringUtils.isEmpty(this.content) || StringUtils.isBlank(this.content)) {
            this.colorView.setBackground(ColorUtil.toColorInt(DEFAULT_COLOR));
            this.textField.setText(this.content);
        } else {
            this.colorView.setBackground(ColorUtil.toColorInt(this.content));
            this.textField.setText(this.content);
        }
        if (this.documentListener != null) {
            this.textField.getDocument().addDocumentListener(this.documentListener);
        }
    }

    @Override
    protected String refreshDataSource() {
        this.content = this.item.getContents()[0];
        return this.content;
    }
}

