/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model.item;

import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import com.immomo.mmpaas.panel.property_panel.model.SwissKnife;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JComponent;

public class NumberItem<T extends JComponent>
extends Item {
    public NumberItem(SwissKnife swissKnife, JComponent view, MyAnnotation myAnnotation, Method setter, String ... getterNames) {
        super(swissKnife, view, myAnnotation, setter, getterNames);
    }

    @Override
    public void updateWithContent(String ... newContents) {
        if (newContents == null || newContents.length == 0) {
            return;
        }
        this.setParams(WidthHeightAdapter.adaptForSetWidthOrSetHeight(newContents));
        if ("".equals(newContents[0])) {
            return;
        }
        this.swissKnife.invoke(this.setter, this.rawValue(newContents));
        this.sendUpdatedNotification();
    }

    @Override
    public String[] getContents() {
        Number retValue = (Number)this.swissKnife.invoke(this.swissKnife.getMethodWithName(this.getterNames[0], new Class[0]), new Object[0]);
        String[] ret2 = WidthHeightAdapter.adaptForGetWidthOrGetHeight(new String[]{String.valueOf(retValue)}, this.getterNames[0]);
        this.setParams(ret2);
        return ret2;
    }

    @Override
    protected Object rawValue(String[] newContent) {
        if (this.isNull(newContent) || "".equals(newContent[0])) {
            return null;
        }
        if (this.swissKnife.isInteger(this.getterNames[0])) {
            return Integer.parseInt(newContent[0]);
        }
        if (this.swissKnife.isFloat(this.getterNames[0])) {
            return Float.valueOf(Float.parseFloat(newContent[0]));
        }
        if (this.swissKnife.isDouble(this.getterNames[0])) {
            return Double.parseDouble(newContent[0]);
        }
        return null;
    }

    private static class WidthHeightAdapter {
        private static final String WRAP_CONTENT_NUMBER = "-2.0";
        private static final String MATCH_PARENT_NUMBER = "-1.0";
        private static final String WRAP_CONTENT = "WRAP_CONTENT";
        private static final String MATCH_PARENT = "MATCH_PARENT";

        private WidthHeightAdapter() {
        }

        private static String[] adaptForSetWidthOrSetHeight(String[] content) {
            if (content[0].equals(WRAP_CONTENT)) {
                content[0] = WRAP_CONTENT_NUMBER;
            } else if (content[0].equals(MATCH_PARENT)) {
                content[0] = MATCH_PARENT_NUMBER;
            }
            return Arrays.copyOf(content, content.length);
        }

        private static String[] adaptForGetWidthOrGetHeight(String[] content, String getterName) {
            if (!WidthHeightAdapter.isWidthOrHeightGetter(getterName)) {
                return Arrays.copyOf(content, content.length);
            }
            if (WidthHeightAdapter.shouldShowWrapContent(content[0])) {
                content[0] = WRAP_CONTENT;
            } else if (WidthHeightAdapter.shouldShowMatchParent(content[0])) {
                content[0] = MATCH_PARENT;
            }
            return Arrays.copyOf(content, content.length);
        }

        private static boolean shouldShowWrapContent(String widthOrHeight) {
            return widthOrHeight.equals(WRAP_CONTENT_NUMBER);
        }

        private static boolean shouldShowMatchParent(String widthOrHeight) {
            return widthOrHeight.equals(MATCH_PARENT_NUMBER);
        }

        private static boolean isWidthOrHeightGetter(String getterName) {
            return "getOriginWidth".equals(getterName) || "getOriginHeight".equals(getterName);
        }
    }
}

