/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model.filter;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ViewFilter {
    private final List<String> baseViewDiscardList = new ArrayList<String>();
    private final List<String> baseViewForceDiscardList = new ArrayList<String>();

    public void addDiscardPropertiesInBaseView(String ... properties) {
        this.baseViewDiscardList.addAll(new ArrayList<String>(Arrays.asList(properties)));
    }

    public void addForceDiscardPropertiesInBaseView(String ... properties) {
        this.baseViewForceDiscardList.addAll(new ArrayList<String>(Arrays.asList(properties)));
    }

    public Map<String, List<Item>> getViewInfoByFilterOut(Map<String, List<Item>> originViewInfo) {
        HashMap<String, List<Item>> filterOuts = new HashMap<String, List<Item>>(originViewInfo);
        for (String viewName : filterOuts.keySet()) {
            List afterFilterItems = (List)filterOuts.get(viewName);
            afterFilterItems = afterFilterItems.stream().filter(item -> !this.shouldFilterOut(item.myAnnotation.ofView(), item.myAnnotation.desc())).collect(Collectors.toList());
            filterOuts.put(viewName, afterFilterItems);
        }
        return filterOuts;
    }

    public boolean shouldFilterOut(String ofView, String property) {
        if (this.isBaseView(ofView)) {
            if (this.shouldForceDiscardIn(this.baseViewForceDiscardList, property)) {
                return true;
            }
            return this.shouldDiscardIn(this.baseViewDiscardList, property);
        }
        return false;
    }

    protected boolean shouldDiscardIn(List<String> discardList, String property) {
        if (this.isPlugin()) {
            return false;
        }
        for (String discard : discardList) {
            if (!property.equals(discard)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldForceDiscardIn(List<String> forceDiscardList, String property) {
        if (forceDiscardList.size() == 0) {
            return false;
        }
        for (String forceDiscard : forceDiscardList) {
            if (!property.equals(forceDiscard)) continue;
            return true;
        }
        return false;
    }

    private boolean isBaseView(String ofView) {
        return ofView.equals("9View");
    }

    private boolean isPlugin() {
        if (Application.getApp() == null) {
            return true;
        }
        return Application.getApp().isPlugin();
    }
}

