/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model;

import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import com.immomo.mmpaas.panel.property_panel.model.SwissKnife;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class ViewInfoTraversal<T extends JComponent> {
    private final T mView;
    private Map<String, HashMap> mViewsInfo;
    private SwissKnife swissKnife;

    public ViewInfoTraversal(T view) {
        this(view, null);
    }

    public ViewInfoTraversal(T view, SwissKnife swissKnife) {
        this.mView = view;
        this.swissKnife = swissKnife;
        this.swissKnife.wireView(view);
        swissKnife.wireAnnotation(MyAnnotation.class);
    }

    public void wireSwissKnife(SwissKnife swissKnife) {
        this.swissKnife = swissKnife;
    }

    public void parseView(ItemTraversal itemTraversal) {
        Method[] methods;
        if (itemTraversal == null) {
            throw new IllegalArgumentException("item ITraversal can't be null");
        }
        Method[] viewMethods = this.swissKnife.getAnnotationMethods();
        Method[] viewWrapperMethods = this.swissKnife.getViewWraperAnnotationMethods();
        for (Method setter : methods = this.concat(viewMethods, viewWrapperMethods)) {
            Method[] getters = this.getGetters(setter);
            MyAnnotation myAnnotation = this.getMyAnnotation(setter);
            Method replaceSetter = this.searchSameMethodInView(setter);
            itemTraversal.traverseView(replaceSetter != null ? replaceSetter : setter, myAnnotation, getters);
        }
    }

    protected Method searchSameMethodInView(Method setter) {
        return this.swissKnife.getMethodCanBeNull(this.mView, setter.getName(), setter.getParameterTypes());
    }

    private Method[] concat(Method[] a, Method[] b) {
        Method[] ret2 = new Method[a.length + b.length];
        System.arraycopy(a, 0, ret2, 0, a.length);
        System.arraycopy(b, 0, ret2, a.length, b.length);
        return ret2;
    }

    private MyAnnotation getMyAnnotation(Method setter) {
        return this.swissKnife.getMyAnnotationWithMethod(setter);
    }

    private Method[] getGetters(Method setter) {
        MyAnnotation annotation = this.getMyAnnotation(setter);
        String[] getterNames = annotation.getterNames();
        int getterCount = this.swissKnife.getterCount(setter);
        Method[] getters = new Method[getterCount];
        for (int i = 0; i < getterCount; ++i) {
            getters[i] = this.swissKnife.getMethodWithName(getterNames[i], new Class[0]);
        }
        return getters;
    }

    public T getView() {
        return this.mView;
    }

    public static interface ItemTraversal {
        public void traverseView(Method var1, MyAnnotation var2, Method ... var3);
    }
}

