/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model;

import com.immomo.mmpaas.panel.property_panel.model.ItemAggregation;
import com.immomo.mmpaas.panel.property_panel.model.Traversal;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewInfoProvider {
    private Map<String, List<Item>> viewProperties;
    private List<String> orderedViewNames;
    private Traversal traversal;

    public ViewInfoProvider(Traversal traversal) {
        this.setTraversal(traversal);
        this.initViewProperties();
    }

    public void setTraversal(Traversal traversal) {
        this.traversal = traversal;
    }

    public void initViewProperties() {
        HashMap<String, List<Item>> originViewProperties = new HashMap<String, List<Item>>(this.traversal.parseView());
        this.orderedViewNames = this.getOrderedViewNames(originViewProperties);
        this.viewProperties = this.getViewProperties(originViewProperties);
        this.updateOrderedViewNames();
    }

    protected void updateOrderedViewNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.orderedViewNames) {
            if (!this.viewProperties.containsKey(name)) continue;
            names.add(name);
        }
        this.orderedViewNames = names;
    }

    public Item getItem(int row, int section) {
        return this.viewProperties.get(this.orderedViewNames.get(section)).get(row);
    }

    public int getViewPropertyCount(int viewIndex) {
        return this.viewProperties.get(this.orderedViewNames.get(viewIndex)).size();
    }

    public int getViewCount() {
        return this.orderedViewNames.size();
    }

    public String getViewName(int index) {
        return this.orderedViewNames.get(index);
    }

    private List<String> getOrderedViewNames(Map<String, List<Item>> originViewProperties) {
        ArrayList<String> orderedViewNames = ItemAggregation.sortViewNames(originViewProperties);
        List<String> viewNamesNotContainNumber = ItemAggregation.clipNumberSectionInViewNames(orderedViewNames);
        return viewNamesNotContainNumber;
    }

    private Map<String, List<Item>> getViewProperties(Map<String, List<Item>> originViewProperties) {
        Map<String, List<Item>> viewPropertiesMap = new HashMap<String, List<Item>>(originViewProperties);
        String selectedViewName = this.getViewName(0);
        viewPropertiesMap = ItemAggregation.filterViewInfo(viewPropertiesMap, selectedViewName);
        viewPropertiesMap = ItemAggregation.clipViewIfNotContainViewInfo(viewPropertiesMap);
        viewPropertiesMap = ItemAggregation.aggregationViewInfo(viewPropertiesMap);
        viewPropertiesMap = ItemAggregation.sortViewInfo(viewPropertiesMap);
        viewPropertiesMap = ItemAggregation.clipViewInfo(viewPropertiesMap);
        return viewPropertiesMap;
    }

    public Map<String, List<Item>> do_not_call_me_just_for_test_file() {
        return this.viewProperties;
    }
}

