/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model;

import com.immomo.mmpaas.panel.property_panel.model.MyAnnotation;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class SwissKnife<T extends JComponent> {
    private T view;
    private Class annotationCls;

    public SwissKnife(T view, Class annotationCls) {
        this.view = view;
        this.annotationCls = annotationCls;
    }

    public SwissKnife() {
    }

    public Object invoke(Object obj, Method method, Object ... parameters) {
        int size = parameters.length;
        Class[] parameterTypes = new Class[size];
        for (int i = 0; i < size; ++i) {
            parameterTypes[i] = parameters[i].getClass();
            if (parameterTypes[i] != Integer.class) continue;
            parameterTypes[i] = Integer.TYPE;
        }
        if (method == null) {
            throw new NullPointerException("Method is null!");
        }
        method.setAccessible(true);
        Object returnType = null;
        try {
            returnType = method.invoke(obj, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnType;
    }

    private Object tryInvoke(Object obj, Method method, Object ... parameters) throws Exception {
        int size = parameters.length;
        Class[] parameterTypes = new Class[size];
        for (int i = 0; i < size; ++i) {
            parameterTypes[i] = parameters[i].getClass();
            if (parameterTypes[i] != Integer.class) continue;
            parameterTypes[i] = Integer.TYPE;
        }
        if (method == null) {
            throw new NullPointerException("Method is null!");
        }
        method.setAccessible(true);
        Object returnType = null;
        returnType = method.invoke(obj, parameters);
        return returnType;
    }

    public Object invoke(Method method, Object ... parameters) {
        try {
            return this.tryInvoke(this.view, method, parameters);
        }
        catch (Exception e) {
            return this.invoke(this.getViewWrapperFromView(), method, parameters);
        }
    }

    public void wireView(T view) {
        this.view = view;
    }

    public void wireAnnotation(Class annotationCls) {
        this.annotationCls = annotationCls;
    }

    public int getAnnotationMethodsCount() {
        return this.getAnnotationMethods().length;
    }

    public Method[] getAnnotationMethodsWithClass(Class cls) {
        Object[] ret2;
        this.annotationClassNullCheck();
        Method[] methods = this.getAllMethodsWithClass(cls);
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Object methodObj : ret2 = Arrays.stream(methods).filter(m -> m.getDeclaredAnnotation(this.annotationCls) != null).toArray()) {
            methodList.add((Method)methodObj);
        }
        Method[] retMethods = methodList.toArray(new Method[ret2.length]);
        return retMethods;
    }

    public Method[] getAnnotationMethods() {
        ArrayList<Method> ret2 = new ArrayList<Method>();
        for (Class<?> current = this.view.getClass(); current != null; current = current.getSuperclass()) {
            try {
                ret2.addAll(Arrays.asList(this.getAnnotationMethodsWithClass(current)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret2.toArray(new Method[ret2.size()]);
    }

    private void annotationClassNullCheck() {
        if (this.annotationCls == null) {
            throw new IllegalArgumentException("AnnotationCls should not be null!!");
        }
    }

    public boolean isMutipleParam(Method method) {
        return this.getParametersCount(method) > 1;
    }

    public boolean isSetterParameterCountEqualToGetterCount(Method setter) {
        this.setAccessible(setter);
        MyAnnotation myAnnotation = this.getMyAnnotationWithMethod(setter);
        if (myAnnotation == null) {
            throw new NullPointerException("[isParameterCountEqualToGetter]no myAnnotation");
        }
        return this.getParametersCount(setter) == myAnnotation.getterNames().length;
    }

    public int getterCount(Method method) {
        MyAnnotation myAnnotation = this.getMyAnnotationWithMethod(method);
        if (myAnnotation == null) {
            return -1;
        }
        return myAnnotation.getterNames().length;
    }

    public int getParametersCount(Method method) {
        method.setAccessible(true);
        return method.getParameterCount();
    }

    public Class[] getParametersTypes(Method method) {
        method.setAccessible(true);
        return method.getParameterTypes();
    }

    private void setAccessible(Method method) {
        if (method.isAccessible()) {
            return;
        }
        method.setAccessible(true);
    }

    public boolean isMutipleParam(String[] getterNames) {
        return TypeParser.isMutipleParam(getterNames);
    }

    public boolean isEnum(String name) {
        return TypeParser.isEnum(name);
    }

    public boolean isColor(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isColor(getter);
    }

    public boolean isString(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isString(getter);
    }

    public boolean isBoolean(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isBoolean(getter);
    }

    public boolean isNumber(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isNumber(getter);
    }

    public boolean isInteger(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isInteger(getter);
    }

    public boolean isFloat(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isFloat(getter);
    }

    public boolean isDouble(String name) {
        if (this.isEnum(name)) {
            return false;
        }
        Method getter = this.getMethodWithName(name, new Class[0]);
        this.setAccessible(getter);
        return TypeParser.isDouble(getter);
    }

    public boolean isString(Field field) {
        field.setAccessible(true);
        return field.getType() == String.class;
    }

    public boolean isEnum(Method method) {
        method.setAccessible(true);
        MyAnnotation myAnnotation = this.getMyAnnotationWithMethod(method);
        return myAnnotation == null ? false : myAnnotation.enumClass() != Object.class;
    }

    public Annotation getAnnotationWithMethod(Method method) {
        return method.getDeclaredAnnotation(this.annotationCls);
    }

    public MyAnnotation getMyAnnotationWithMethod(Method method) {
        MyAnnotation myAnnotation = null;
        Annotation annotation = this.getAnnotationWithMethod(method);
        if (annotation instanceof MyAnnotation) {
            myAnnotation = (MyAnnotation)annotation;
        }
        return myAnnotation;
    }

    public Method[] getAllMethodsWithClass(Class cls) {
        if (this.view == null) {
            throw new IllegalArgumentException("View that to be reflect should not be null!");
        }
        Method[] methods = cls.getDeclaredMethods();
        return methods;
    }

    public String[] getAnnotationMethodNames() {
        this.annotationClassNullCheck();
        Method[] annotationMethods = this.getAnnotationMethods();
        ArrayList<String> ret2 = new ArrayList<String>();
        for (int i = 0; i < annotationMethods.length; ++i) {
            ret2.add(annotationMethods[i].getName());
        }
        return ret2.toArray(new String[ret2.size()]);
    }

    public Method getMethodWithName(String methodName, Class<?> ... parameterTypes) {
        String name = MethodNameParser.getMethodName(methodName);
        try {
            return this.getMethod(this.view, name, parameterTypes);
        }
        catch (Exception e) {
            return this.getMethod(this.getViewWrapperFromView(), name, parameterTypes);
        }
    }

    public Method getMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Method ret2 = null;
        if (methodName == null || methodName == "") {
            throw new NullPointerException("Method name can't be null");
        }
        for (Class<?> current = obj.getClass(); ret2 == null && current != null; current = current.getSuperclass()) {
            try {
                ret2 = current.getDeclaredMethod(methodName, parameterTypes);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret2 == null) {
            throw new NullPointerException("Method--" + methodName + " can't find");
        }
        ret2.setAccessible(true);
        return ret2;
    }

    public Method getMethodCanBeNull(Object obj, String methodName, Class<?> ... parameterTypes) {
        try {
            return this.getMethod(this.view, methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Field getFieldWithName(String fieldName) {
        return this.getFieldWithName(fieldName, this.view.getClass());
    }

    public Field getFieldWithName(String fieldName, Class cls) {
        Field field = this.fieldWithName(fieldName, cls);
        return field;
    }

    private Field fieldWithName(String name, Class cls) {
        try {
            return this.getField(name, cls);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Field getField(String name, Class cls) {
        Field ret2 = null;
        for (Class current = cls; ret2 == null && current != null; current = current.getSuperclass()) {
            try {
                ret2 = current.getDeclaredField(name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret2 != null) {
            ret2.setAccessible(true);
        }
        return ret2;
    }

    public Method[] getViewWraperAnnotationMethods() {
        Object mViewWrapper = this.getViewWrapperFromView();
        return this.getAnnotationMethodsWithClass(mViewWrapper.getClass());
    }

    public Method getViewWrapperMethod(String methodName, Class<?> ... parameterTypes) {
        Object mViewWrapper = this.getViewWrapperFromView();
        return this.getMethod(mViewWrapper, methodName, parameterTypes);
    }

    private Object getViewWrapperFromView() {
        return this.getFieldValue("mViewWrapper", this.view.getClass());
    }

    public Object getFieldValue(String name, Class cls) {
        return this.fieldValueWithName(name, cls);
    }

    public Object getFieldValue(String name) {
        return this.fieldValueWithName(name);
    }

    private Object fieldValueWithName(String name) {
        try {
            Field ret2 = this.getFieldWithName(name);
            ret2.setAccessible(true);
            return ret2.get(this.view);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class getFieldType(Field field) {
        return field.getType();
    }

    private Object fieldValueWithName(String name, Class cls) {
        try {
            Field ret2 = this.getFieldWithName(name, cls);
            ret2.setAccessible(true);
            return ret2.get(this.view);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Field[] getFieldsWithClass(Class cls) {
        try {
            return cls.getDeclaredFields();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Integer> getEnumMap(MyAnnotation myAnnotation) {
        HashMap<String, Integer> enumMap = new HashMap<String, Integer>();
        Field[] fields = this.getEnumFieldsWithClass(myAnnotation.enumClass());
        for (int i = 0; i < fields.length; ++i) {
            enumMap.put(fields[i].getName(), (Integer)this.getEnumValueWithField(fields[i], myAnnotation));
        }
        return enumMap;
    }

    public Field[] getEnumFieldsWithClass(Class cls) {
        try {
            return cls.getDeclaredFields();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getEnumValueWithField(Field enumField, MyAnnotation myAnnotation) {
        Object ret2 = null;
        try {
            ret2 = enumField.get(myAnnotation.enumClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret2;
    }

    private static class MethodNameParser {
        private MethodNameParser() {
        }

        public static String getMethodName(String content) {
            String parseName = "";
            if (content.contains("(")) {
                char cur2;
                char[] charArray = content.toCharArray();
                for (int i = 0; i < charArray.length && (cur2 = charArray[i]) != '('; ++i) {
                    parseName = parseName + charArray[i];
                }
                return parseName;
            }
            return content;
        }
    }

    private static class TypeParser {
        private TypeParser() {
        }

        public static boolean isEnum(String name) {
            return name.contains("(");
        }

        public static boolean isInteger(Method getter) {
            return getter.getReturnType().equals(Integer.TYPE) || getter.getReturnType().equals(Integer.class);
        }

        public static boolean isFloat(Method getter) {
            return getter.getReturnType().equals(Float.TYPE) || getter.getReturnType().equals(Float.class);
        }

        public static boolean isDouble(Method getter) {
            return getter.getReturnType().equals(Double.TYPE) || getter.getReturnType().equals(Double.class);
        }

        public static boolean isNumber(Method getter) {
            return getter.getReturnType().equals(Number.class) || getter.getReturnType().equals(Integer.TYPE) || getter.getReturnType().equals(Double.TYPE) || getter.getReturnType().equals(Float.TYPE);
        }

        public static boolean isBoolean(Method getter) {
            return getter.getReturnType().equals(Boolean.TYPE) || getter.getReturnType().equals(Boolean.class);
        }

        public static boolean isString(Method getter) {
            return getter.getReturnType().equals(String.class);
        }

        public static boolean isColor(Method getter) {
            return getter.getReturnType().equals(Color.class);
        }

        public static boolean isMutipleParam(String[] getterNames) {
            return getterNames.length > 1;
        }
    }
}

