/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.model;

import com.immomo.mmpaas.panel.property_panel.model.filter.ViewFilter;
import com.immomo.mmpaas.panel.property_panel.model.filter.ViewFilterBuilder;
import com.immomo.mmpaas.panel.property_panel.model.item.GroupItem;
import com.immomo.mmpaas.panel.property_panel.model.item.Item;
import com.immomo.mmpaas.panel.property_panel.model.item.SelectionItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ItemAggregation {
    public static List<Item> aggregation(List<Item> items) {
        HashMap<Integer, List<Item>> map = new HashMap<Integer, List<Item>>();
        for (int i = 0; i < items.size(); ++i) {
            if (!map.containsKey(items.get(i).descIndex())) {
                map.put(items.get(i).descIndex(), new ArrayList());
                map.get(items.get(i).descIndex()).add(items.get(i));
                continue;
            }
            map.get(items.get(i).descIndex()).add(items.get(i));
        }
        return ItemAggregation.mergeGroupItem(map);
    }

    private static List<Item> mergeGroupItem(Map<Integer, List<Item>> aggregationItems) {
        List<Item> items = new ArrayList<Item>();
        for (Integer key : aggregationItems.keySet()) {
            if (aggregationItems.get(key).size() == 1) {
                items.add(aggregationItems.get(key).get(0));
                continue;
            }
            GroupItem groupItem = new GroupItem();
            groupItem.desc = aggregationItems.get((Object)key).get((int)0).myAnnotation.desc().substring(0, 5) + aggregationItems.get((Object)key).get((int)0).myAnnotation.groupName();
            groupItem.selectionId = aggregationItems.get((Object)key).get((int)0).selectionId;
            groupItem.myAnnotation = aggregationItems.get((Object)key).get((int)0).myAnnotation;
            for (int i = 0; i < aggregationItems.get(key).size(); ++i) {
                Item childItem = aggregationItems.get(key).get(i);
                childItem.desc = childItem.realDesc();
                groupItem.addItem(childItem);
            }
            items.add(groupItem);
        }
        items = ItemAggregation.aggregationSelectionItem(items);
        return items;
    }

    private static List<Item> aggregationSelectionItem(List<Item> items) {
        HashMap<String, List<Item>> map = new HashMap<String, List<Item>>();
        for (int i = 0; i < items.size(); ++i) {
            if (!map.containsKey(items.get((int)i).selectionId)) {
                map.put(items.get((int)i).selectionId, new ArrayList());
            }
            ((List)map.get(items.get((int)i).selectionId)).add(items.get(i));
        }
        return ItemAggregation.mergeSelectionItem(map);
    }

    private static List<Item> mergeSelectionItem(Map<String, List<Item>> aggregationItems) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String key : aggregationItems.keySet()) {
            if (key.length() > 0) {
                SelectionItem selectionItem = new SelectionItem();
                selectionItem.desc = aggregationItems.get((Object)key).get((int)0).myAnnotation.desc().substring(0, 5) + key;
                for (int i = 0; i < aggregationItems.get(key).size(); ++i) {
                    Item childItem = aggregationItems.get(key).get(i);
                    selectionItem.addItem(childItem);
                }
                items.add(selectionItem);
                continue;
            }
            for (int i = 0; i < aggregationItems.get(key).size(); ++i) {
                Item commonItem = aggregationItems.get(key).get(i);
                items.add(commonItem);
            }
        }
        return items;
    }

    public static List<Item> sortItems(List<Item> items) {
        ArrayList<Item> ret2 = new ArrayList<Item>(items);
        ret2.sort(Comparator.comparingInt(Item::descIndex));
        return ret2;
    }

    public static List<Item> clipDescFlag(List<Item> items) {
        ArrayList<Item> ret2 = new ArrayList<Item>(items);
        ret2.forEach(item -> {
            item.desc = item.realDesc();
        });
        return ret2;
    }

    @NotNull
    public static List<String> clipNumberSectionInViewNames(List<String> orderedViewNames) {
        List<String> list = orderedViewNames.stream().map(n -> n.substring(1)).collect(Collectors.toList());
        if (list == null) {
            ItemAggregation.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static ArrayList<String> sortViewNames(Map<String, List<Item>> originViewProperties) {
        ArrayList<String> orderedViewNames = new ArrayList<String>(new ArrayList<String>(originViewProperties.keySet()));
        orderedViewNames.sort(Comparator.comparingInt(o -> Integer.parseInt(o.substring(0, 1))));
        ArrayList<String> arrayList = orderedViewNames;
        if (arrayList == null) {
            ItemAggregation.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static Map<String, List<Item>> filterViewInfo(Map<String, List<Item>> map, String selectedViewName) {
        ViewFilter viewFilter = ViewFilterBuilder.buildWith(selectedViewName);
        map = viewFilter.getViewInfoByFilterOut(map);
        return map;
    }

    @NotNull
    public static Map<String, List<Item>> aggregationViewInfo(Map<String, List<Item>> viewInfo) {
        HashMap<String, List<Item>> afterAggregationViewInfo = new HashMap<String, List<Item>>();
        for (String viewKey : viewInfo.keySet()) {
            List<Item> items = viewInfo.get(viewKey);
            items = ItemAggregation.aggregation(items);
            afterAggregationViewInfo.put(viewKey, items);
        }
        HashMap<String, List<Item>> hashMap = afterAggregationViewInfo;
        if (hashMap == null) {
            ItemAggregation.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, List<Item>> sortViewInfo(Map<String, List<Item>> viewInfo) {
        HashMap<String, List<Item>> afterSortViewInfo = new HashMap<String, List<Item>>();
        for (String viewKey : viewInfo.keySet()) {
            List<Item> items = viewInfo.get(viewKey);
            items = ItemAggregation.sortItems(items);
            afterSortViewInfo.put(viewKey, items);
        }
        HashMap<String, List<Item>> hashMap = afterSortViewInfo;
        if (hashMap == null) {
            ItemAggregation.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, List<Item>> clipViewInfo(Map<String, List<Item>> viewInfo) {
        HashMap<String, List<Item>> afterClipViewInfo = new HashMap<String, List<Item>>();
        for (String viewKey : viewInfo.keySet()) {
            List<Item> items = viewInfo.get(viewKey);
            items = ItemAggregation.clipDescFlag(items);
            afterClipViewInfo.put(viewKey.substring(1), items);
        }
        HashMap<String, List<Item>> hashMap = afterClipViewInfo;
        if (hashMap == null) {
            ItemAggregation.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, List<Item>> clipViewIfNotContainViewInfo(Map<String, List<Item>> viewInfo) {
        HashMap<String, List<Item>> afterClipViewInfo = new HashMap<String, List<Item>>();
        for (String viewKey : viewInfo.keySet()) {
            List<Item> items = viewInfo.get(viewKey);
            if (items.size() <= 0) continue;
            afterClipViewInfo.put(viewKey, items);
        }
        HashMap<String, List<Item>> hashMap = afterClipViewInfo;
        if (hashMap == null) {
            ItemAggregation.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/immomo/mmpaas/panel/property_panel/model/ItemAggregation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clipNumberSectionInViewNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortViewNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "aggregationViewInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sortViewInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "clipViewInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "clipViewIfNotContainViewInfo";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

