/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel.controller;

import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.property_panel.controller.TableViewController;
import com.immomo.mmpaas.panel.property_panel.model.ViewInfoProvider;
import com.immomo.mmpaas.panel.property_panel.view.ItemView;
import com.immomo.mmpaas.panel.property_panel.view.ItemViewBuilder;
import com.immomo.mmpaas.panel.property_panel.view.custom.CusButton;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSeparator;

public class PropertyBoardViewController
extends TableViewController {
    private ViewInfoProvider viewInfoProvider;

    public PropertyBoardViewController(double width, double height, Object data) {
        super(width, height, data);
    }

    @Override
    protected void setUpData(Object data) {
        this.viewInfoProvider = (ViewInfoProvider)data;
    }

    @Override
    public int numberOfRowsInSection(int section) {
        return this.viewInfoProvider.getViewPropertyCount(section);
    }

    @Override
    public int numberOfSections() {
        return this.viewInfoProvider.getViewCount();
    }

    @Override
    public JComponent headerViewForSection(int section) {
        CusButton headerView = new CusButton(this.viewInfoProvider.getViewName(section), ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_down), 0);
        headerView.setSelectedImage(ImageLoader.getInstance().loadProjectImageIcon(P.icons.arrow_right));
        headerView.setFont(new Font(null, 0, Theme.dark.propertyViewSize));
        headerView.setOpaque(false);
        headerView.setForeground(Theme.dark.propertyTextColor);
        headerView.setHorizontalAlignment(2);
        headerView.setButtonClickedListener(() -> {
            JComponent sectionContentView;
            sectionContentView.setVisible(!(sectionContentView = this.tableView.getSectionContentView(section)).isVisible());
        });
        return headerView;
    }

    @Override
    public JComponent cellForRowAtIndexPath(int row, int section) {
        ItemView itemView = ItemViewBuilder.buildWithItem(this.viewInfoProvider.getItem(row, section));
        Box itemContainer = Box.createHorizontalBox();
        itemContainer.setMaximumSize(new Dimension(Short.MAX_VALUE, itemView.getPanel().getPreferredSize().height));
        itemContainer.add(Box.createHorizontalStrut(15));
        itemContainer.add(itemView.getPanel());
        itemContainer.add(Box.createHorizontalStrut(10));
        return itemContainer;
    }

    @Override
    public int heightForSeparator() {
        return 10;
    }

    @Override
    public JComponent footerViewForSection(int section) {
        JSeparator footerView = new JSeparator(0);
        footerView.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        footerView.setForeground(Theme.dark.propertySeparatorColor);
        return footerView;
    }
}

