/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel;

import com.sun.prism.paint.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ViewProperty {
    public static final int Null = 0;
    public static final int Boolean = 1;
    public static final int Number = 2;
    public static final int String = 4;
    public static final int Color = 8;
    public static final int Enum = 16;
    public static final int Int = 32;
    public static final int Unsigned = 64;
    public static final int EnumOr = 128;
    public static final int HasLimit = 256;
    public static final int LimitIndex = 9;
    public final String name;
    public final String desc;
    public final int[] type;
    public final int paramCount;
    public double[] limited;
    public Map<String, Object> enums;
    private Map<Class, Integer> typeMap;

    public ViewProperty(String name, String desc, int paramCount) {
        this.name = name;
        this.desc = desc;
        this.paramCount = paramCount;
        this.type = new int[paramCount];
        this.setUpTypeMap();
    }

    public ViewProperty addEnums(String name, Object value) {
        if (this.enums == null) {
            this.enums = new LinkedHashMap<String, Object>();
        }
        this.enums.put(name, value);
        return this;
    }

    public Set<String> getEnumNames() {
        if (this.enums == null) {
            return null;
        }
        return this.enums.keySet();
    }

    public ViewProperty addType(int index, int type2) {
        int n = index;
        this.type[n] = this.type[n] | type2;
        return this;
    }

    public int getType(int index) {
        return this.type[index];
    }

    public static boolean hasType(int src, int type2) {
        return (src & type2) == type2;
    }

    public ViewProperty addBoolean(int index) {
        return this.addType(index, 1);
    }

    public ViewProperty addNumber(int index) {
        return this.addType(index, 2);
    }

    public ViewProperty addLimited(int index, double min2, double max2) {
        int offset;
        int li;
        if (this.limited == null) {
            this.limited = new double[2];
            li = 0;
            offset = 0;
        } else {
            li = this.limited.length;
            double[] temp = new double[li + 2];
            System.arraycopy(this.limited, 0, temp, 0, li);
            this.limited = temp;
            offset = li >> 1;
        }
        this.limited[li] = min2;
        this.limited[li + 1] = max2;
        int t = 0x100 | offset << 9;
        return this.addType(index, t);
    }

    public boolean hasLimited(int index) {
        return ViewProperty.hasType(this.type[index], 256);
    }

    public double getMinLimited(int index) {
        int offset = this.type[index] >> 9 & 0xFF;
        if (offset == 0) {
            return this.limited[0];
        }
        return this.limited[1 << offset];
    }

    public double getMaxLimited(int index) {
        int offset = this.type[index] >> 9 & 0xFF;
        if (offset == 0) {
            return this.limited[1];
        }
        return this.limited[1 << offset + 1];
    }

    public ViewProperty addInt(int index) {
        return this.addType(index, 34);
    }

    public ViewProperty addUnsigned(int index) {
        return this.addType(index, 66);
    }

    public ViewProperty addUnsignedInt(int index) {
        return this.addType(index, 98);
    }

    public ViewProperty addString(int index) {
        return this.addType(index, 4);
    }

    public ViewProperty addColor(int index) {
        return this.addType(index, 8);
    }

    public ViewProperty addEnum(int index, boolean or) {
        if (or) {
            return this.addType(index, 144);
        }
        return this.addType(index, 16);
    }

    private void setUpTypeMap() {
        this.typeMap = new HashMap<Class, Integer>();
        this.typeMap.put(null, 0);
        this.typeMap.put(java.lang.Boolean.TYPE, 1);
        this.typeMap.put(Number.class, 2);
        this.typeMap.put(String.class, 4);
        this.typeMap.put(Color.class, 8);
        this.typeMap.put(Enum.class, 16);
        this.typeMap.put(Integer.TYPE, 32);
    }

    public int getType(Class typeCls) {
        if (this.typeMap == null || this.typeMap.size() <= 0) {
            return Integer.MIN_VALUE;
        }
        return this.typeMap.get(typeCls);
    }
}

