/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.property_panel;

import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.panel.property_panel.controller.PropertyBoardViewController;
import com.immomo.mmpaas.panel.property_panel.model.SwissKnife;
import com.immomo.mmpaas.panel.property_panel.model.Traversal;
import com.immomo.mmpaas.panel.property_panel.model.ViewInfoProvider;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PropertyPanel
extends BasePanel
implements BroadCastReceiver {
    private JPanel panel;
    private JScrollPane scrollview;

    public PropertyPanel(Context context2) {
        super(context2);
        this.width = 300;
        this.height = context2.getHeight();
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBackground(context2.getTheme().propertyBackground);
        this.panel.setOpaque(true);
        context2.registerReceiver(context2, "BC_PROPERTY_UPDATE", this);
        context2.registerReceiver(context2, "BC_MAIN_TAB_SELECTED", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_CLICK", this);
        context2.registerReceiver(context2, "BC_PROPERTY_DISPLAY", this);
    }

    @Override
    public void build() {
        this.scrollview = new JBScrollPane(-1);
        this.scrollview.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollview.setPreferredSize(new Dimension(this.width, this.height));
        this.scrollview.getViewport().setBackground(this.context.getTheme().propertyBackground);
        this.panel.add(this.scrollview);
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_PROPERTY_UPDATE", this);
        this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_CLICK", this);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_MAIN_TAB_SELECTED": {
                int type2 = (Integer)msg.msg;
                if (type2 == 1) {
                    if (!this.visible) {
                        this.visible = true;
                        context2.updatePanel(this);
                    }
                    context2.updatePanel(this);
                    break;
                }
                if (type2 != 2 || !this.visible) break;
                this.visible = false;
                context2.updatePanel(this);
                break;
            }
            case "BC_PHONE_TOUCH_CLICK": 
            case "BC_PROPERTY_UPDATE": {
                if (!this.visible) {
                    this.visible = true;
                }
                Traversal<JComponent> traversal = new Traversal<JComponent>((JComponent)msg.msg, new SwissKnife());
                ViewInfoProvider viewInfoProvider = new ViewInfoProvider(traversal);
                PropertyBoardViewController vc = new PropertyBoardViewController(0.0, 0.0, viewInfoProvider);
                this.scrollview.setViewportView((Component)((Object)vc.getTableView()));
                context2.updatePanel(this);
                break;
            }
            case "BC_PROPERTY_DISPLAY": {
                this.scrollview.getViewport().removeAll();
                this.scrollview.revalidate();
            }
        }
        this.panel.revalidate();
        return false;
    }
}

