/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.message;

import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.panel.message.Message;
import com.immomo.mmpaas.panel.message.bean.MessageBean;
import com.immomo.mmpaas.utils.FileUtil;
import com.immomo.mmpaas.utils.HtmlMsgUtil;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class MessagePanel
extends BasePanel
implements BroadCastReceiver {
    private JComponent panel;
    private JBScrollPane scrollview;
    private JTextPane textArea;

    public MessagePanel(Context context2) {
        super(context2);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.panel = new JPanel();
        this.panel.setLayout(borderLayout);
        this.panel.setBackground(context2.getTheme().backgroundColor);
        Message.getManager().init(context2);
        this.panel.setVisible(false);
        this.initTopView();
        this.initMessageView();
        context2.registerReceiver(context2, "BC_MESSAGE_SHOW", this);
        context2.registerReceiver(context2, "BC_MESSAGE_CLEAR", this);
        context2.registerReceiver(context2, "BC_MESSAGE_ADD", this);
    }

    @Override
    public void build() {
        super.build();
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_MESSAGE_ADD", this);
        this.context.unregisterReceiver("BC_MESSAGE_SHOW", this);
        this.context.unregisterReceiver("BC_MESSAGE_CLEAR", this);
    }

    private void initTopView() {
        JPanel topPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        topPanel.setLayout(borderLayout);
        topPanel.setOpaque(true);
        topPanel.setBackground(null);
        topPanel.setBorder(new BorderUIResource.LineBorderUIResource(this.context.getTheme().borderColor));
        topPanel.setPreferredSize(new Dimension(this.panel.getWidth(), 20));
        JLabel titleLabel = new JLabel();
        titleLabel.setText("message");
        titleLabel.setPreferredSize(new Dimension(80, 20));
        titleLabel.setForeground(this.context.getTheme().textColor);
        titleLabel.setOpaque(true);
        titleLabel.setBackground(null);
        titleLabel.setFont(new Font(null, 0, 12));
        titleLabel.setBorder(null);
        topPanel.add((Component)titleLabel, "West");
        JPanel operPanel = new JPanel(new BorderLayout());
        operPanel.setBackground(null);
        topPanel.add((Component)operPanel, "East");
        JLabel closeLabel = new JLabel();
        closeLabel.setOpaque(false);
        closeLabel.setBackground(null);
        closeLabel.setIcon(ImageLoader.getInstance().loadProjectImageIcon(P.icons.ic_close));
        closeLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        operPanel.add((Component)closeLabel, "East");
        closeLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MessagePanel.this.panel.setVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel clearLabel = new JLabel();
        clearLabel.setOpaque(false);
        clearLabel.setBackground(null);
        clearLabel.setIcon(ImageLoader.getInstance().loadProjectImageIcon(P.icons.ic_clear));
        clearLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        operPanel.add((Component)clearLabel, "West");
        clearLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Message.clear();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBackground(null);
        jPanel.setOpaque(true);
        topPanel.add((Component)jPanel, "Center");
        this.panel.add((Component)topPanel, "North");
    }

    private void initMessageView() {
        this.textArea = new JTextPane();
        this.textArea.setBackground(this.context.getTheme().backgroundColor);
        this.textArea.setEditable(false);
        this.textArea.setContentType("text/html");
        this.buildHtml();
        this.textArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                String href;
                String[] res;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (res = HtmlMsgUtil.dealHref(href = e.getDescription())) != null && res.length > 0) {
                    for (int i = 0; i < res.length; ++i) {
                        FileUtil.openLocalFile(res[i]);
                    }
                }
            }
        });
        this.scrollview = new JBScrollPane();
        this.scrollview.setBorder(null);
        this.scrollview.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollview.setViewportView((Component)this.textArea);
        this.panel.add((Component)this.scrollview, "Center");
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_MESSAGE_ADD": {
                MessageBean messageBean = (MessageBean)msg.msg;
                this.addMessageView(messageBean);
                break;
            }
            case "BC_MESSAGE_SHOW": {
                this.panel.setVisible(!this.panel.isVisible());
                break;
            }
            case "BC_MESSAGE_CLEAR": {
                this.textArea.setText("");
            }
        }
        return false;
    }

    private void addMessageView(MessageBean messageBean) {
        try {
            Document doc = this.textArea.getDocument();
            SimpleAttributeSet set2 = new SimpleAttributeSet();
            switch (messageBean.type) {
                case TIP: {
                    StyleConstants.setForeground(set2, this.context.getTheme().messageTipColor);
                    doc.insertString(doc.getLength(), "\u63d0\u793a\uff1a" + messageBean.message + "\n", set2);
                    break;
                }
                case WARN: {
                    StyleConstants.setForeground(set2, this.context.getTheme().messageWarnColor);
                    doc.insertString(doc.getLength(), "\u8b66\u544a\uff1a" + messageBean.message + "\n", set2);
                    break;
                }
                case ERROR: {
                    if (!this.panel.isVisible()) {
                        this.panel.setVisible(true);
                        return;
                    }
                    StyleConstants.setForeground(set2, this.context.getTheme().messageErrorColor);
                    doc.insertString(doc.getLength(), "\u9519\u8bef\uff1a" + messageBean.message + "\n", set2);
                    break;
                }
                case HTML: {
                    if (!this.panel.isVisible()) {
                        this.panel.setVisible(true);
                    }
                    EditorKit kit = this.textArea.getEditorKit();
                    StringReader reader = new StringReader("\u63d0\u793a\uff1a" + messageBean.message + "\n");
                    kit.read(reader, doc, doc.getLength());
                    break;
                }
                case RESULT: {
                    if (!this.panel.isVisible()) {
                        this.panel.setVisible(true);
                    }
                    StyleConstants.setForeground(set2, this.context.getTheme().messageResultColor);
                    doc.insertString(doc.getLength(), "\u5bf9\u6bd4\u7ed3\u679c\uff1a" + messageBean.message + "\n", set2);
                }
            }
            this.scrollview.revalidate();
            this.scrollview.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildHtml() {
        EditorKit kit = this.textArea.getEditorKit();
        Document doc = this.textArea.getDocument();
        StringReader reader = new StringReader(HtmlMsgUtil.setStyle());
        try {
            kit.read(reader, doc, doc.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

