/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.maintab;

import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.maintab.IMainTabView;
import com.immomo.mmpaas.panel.maintab.MainTabPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class MainTabView
implements IMainTabView,
ItemListener {
    private Context context;
    private MainTabPanel mRootPanel;
    private ButtonGroup group;
    private JRadioButton editor;
    private JRadioButton design;
    private OnMainTabSelectedLisenter selectedLisenter;

    public MainTabView(Context context2, MainTabPanel panel) {
        this.context = context2;
        this.mRootPanel = panel;
        this.initView();
    }

    private void initView() {
        Theme theme = this.context.getTheme();
        int width = this.mRootPanel.getWidth();
        int height = this.mRootPanel.getHeight() - 4;
        this.group = new ButtonGroup();
        this.design = new JRadioButton("Design");
        this.editor = new JRadioButton("Text");
        this.design.setIcon(new RadioIcon(false));
        this.design.setBounds(1, 1, 98, height);
        this.design.setSelectedIcon(new RadioIcon(true));
        this.design.setFont(new Font(null, 0, 12));
        this.design.setForeground(theme.textColor);
        this.design.setHorizontalAlignment(0);
        this.editor.setIcon(new RadioIcon(false));
        this.editor.setBounds(101, 1, 98, height);
        this.editor.setSelectedIcon(new RadioIcon(true));
        this.editor.setFont(new Font(null, 0, 12));
        this.editor.setForeground(theme.textColor);
        this.editor.setHorizontalAlignment(0);
        this.group.add(this.design);
        this.group.add(this.editor);
        this.mRootPanel.getComponent().add(this.design);
        this.mRootPanel.getComponent().add(this.editor);
        this.design.addItemListener(this);
        this.editor.addItemListener(this);
    }

    @Override
    public void selectTab(int key) {
        switch (key) {
            case 1: {
                this.design.setSelected(true);
                break;
            }
            case 2: {
                this.editor.setSelected(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int type2 = e.getSource() == this.design ? 1 : 2;
        if (this.selectedLisenter != null) {
            this.selectedLisenter.onTabSelected(type2);
        }
    }

    public static JRadioButton getSelection(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    public void setSelectedLisenter(OnMainTabSelectedLisenter selectedLisenter) {
        this.selectedLisenter = selectedLisenter;
    }

    public static interface OnMainTabSelectedLisenter {
        public void onTabSelected(int var1);
    }

    private class RadioIcon
    implements Icon {
        private final int padding = 2;
        private boolean isSelected = false;

        public RadioIcon(boolean isSelected) {
            this.isSelected = isSelected;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Theme theme = MainTabView.this.context.getTheme();
            Color color = this.isSelected ? theme.selectBackground : theme.backgroundColor;
            g.setColor(color);
            g.fillRoundRect(2, 2, c.getWidth() - 4, c.getHeight() - 4, 6, 6);
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }
}

