/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.editor.view;

import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.panel.editor.EditorFeildPanel;
import com.immomo.mmpaas.panel.editor.base.IEditorFeildRepository;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditorFeildView
implements IEditorFeildRepository.IBaseEditorFView<byte[], JTextArea>,
DocumentListener {
    private IEditorFeildRepository.IBaseEditorController<EditorFeildView, String> controller;
    private Context context;
    private EditorFeildPanel mRootPanel;
    private JTextArea mEditorTextArea;
    private JScrollPane scrollPane;

    public EditorFeildView(Context context2, EditorFeildPanel editorFeildPanel, IEditorFeildRepository.IBaseEditorController controller) {
        this.controller = controller;
        this.context = context2;
        this.mRootPanel = editorFeildPanel;
        this.controller.setView(this);
    }

    @Override
    public void initPanel() {
        Theme theme = this.context.getTheme();
        JComponent panel = this.mRootPanel.getComponent();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollPane.getHorizontalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollPane.setBorder(null);
        panel.add((Component)this.scrollPane, "Center");
        this.mEditorTextArea = new JTextArea();
        this.mEditorTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorFeildView.this.mEditorTextArea.getText().equals("search")) {
                    EditorFeildView.this.mEditorTextArea.setText("");
                }
            }
        });
        this.mEditorTextArea.getDocument().addDocumentListener(this);
        this.mEditorTextArea.setLineWrap(false);
        this.mEditorTextArea.setMargin(new Insets(12, 12, 12, 12));
        this.mEditorTextArea.setForeground(theme.textColor);
        this.mEditorTextArea.setBackground(theme.backgroundColor);
        this.mEditorTextArea.setVisible(true);
        this.mEditorTextArea.setFont(new Font("\u6977\u4f53", 1, 14));
        this.scrollPane.setViewportView(this.mEditorTextArea);
    }

    @Override
    public void show(byte[] data) {
        if (data != null) {
            this.mEditorTextArea.setText(new String(data));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.controller.sendComponent(this.mEditorTextArea.getText());
    }

    @Override
    public JTextArea getTextArea() {
        return this.mEditorTextArea;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

