/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.editor;

import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.editor.base.IEditorFeildRepository;
import com.immomo.mmpaas.panel.editor.controller.EditorFeildController;
import com.immomo.mmpaas.panel.editor.model.EditorFeildModel;
import com.immomo.mmpaas.panel.editor.view.EditorFeildView;
import com.immomo.mmpaas.utils.CurrentPathUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EditorFeildPanel
extends BasePanel
implements BroadCastReceiver {
    private JComponent panel;
    private IEditorFeildRepository.IBaseEditorController controller;
    private IEditorFeildRepository.IBaseEditorFView view;
    private String filePath;

    public EditorFeildPanel(Context context2) {
        super(context2);
        this.visible = false;
        context2.registerReceiver(context2, "BC_LOAD_CODE_FILE", this);
        context2.registerReceiver(context2, "BC_MAIN_TAB_SELECTED", this);
    }

    @Override
    public void build() {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setVisible(this.visible);
        this.panel.setPreferredSize(new Dimension(this.width, this.height));
        this.controller = new EditorFeildController(new EditorFeildModel());
        this.view = new EditorFeildView(this.context, this, this.controller);
        this.view.initPanel();
        Box horBox = Box.createHorizontalBox();
        JButton save = new JButton("Read");
        save.addActionListener(e -> BroadCastManager.getManager().sendAsync(this.context, BroadCastMessage.obtain("BC_LOAD_CODE_FILE", CurrentPathUtils.getCopySourceFile("main.lua"))));
        horBox.add(save);
        JButton btn = new JButton("Save");
        btn.addActionListener(e -> {
            this.controller.save(this.filePath);
            this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_PHOTO_PANEL_REFRESH"));
        });
        horBox.add(btn);
        this.panel.add((Component)horBox, "South");
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_LOAD_CODE_FILE", this);
        this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        Object path = msg.msg;
        switch (msg.key) {
            case "BC_LOAD_CODE_FILE": {
                if (!(path instanceof String)) break;
                this.filePath = path.toString();
                this.controller.load(this.filePath);
                context2.updatePanel(this);
                break;
            }
            case "BC_MAIN_TAB_SELECTED": {
                int type2 = (Integer)msg.msg;
                if (type2 == 2) {
                    if (!this.visible) {
                        this.visible = true;
                        context2.updatePanel(this);
                    }
                } else if (type2 == 1 && this.visible) {
                    this.visible = false;
                    context2.updatePanel(this);
                }
                this.panel.revalidate();
            }
        }
        return false;
    }
}

