/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar.view;

import com.immomo.mmpaas.base.BaseLifeCyclePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.panel.devicetoolbar.base.IStateBarController;
import com.immomo.mmpaas.panel.devicetoolbar.base.IStateBarView;
import com.immomo.mmpaas.panel.devicetoolbar.view.DeviceToolbar;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class StateBarView
extends BaseLifeCyclePanel
implements IStateBarView,
ItemListener {
    private final IStateBarController controller;
    private final JPanel mRootPanel;
    private JPanel panel;
    private JComboBox<String> stateBarBox;
    private Map<Integer, String> mData;

    public StateBarView(JPanel mRootPanel, IStateBarController controller, Context context2) {
        super(context2);
        this.mRootPanel = mRootPanel;
        this.controller = controller;
        this.context = context2;
        controller.setView(this);
        this.initView();
        controller.load();
    }

    private void initView() {
        this.panel = new JPanel();
        this.panel.setBackground(this.context.getTheme().backgroundColor);
        this.stateBarBox = this.makeNewMenu();
        this.mRootPanel.add(this.panel);
    }

    private JComboBox<String> makeNewMenu() {
        JComboBox<String> cmb = new JComboBox<String>();
        cmb.addItemListener(this);
        cmb.setRenderer(new DeviceToolbar.TrueFalseComboRenderer());
        cmb.setUI(new DeviceToolbar.ComboBoxUI());
        cmb.setForeground(this.context.getTheme().textColor);
        cmb.setBackground(this.context.getTheme().backgroundColor);
        cmb.setVisible(true);
        this.panel.add(cmb);
        return cmb;
    }

    @Override
    public void showList(Map<Integer, String> styleList) {
        this.mData = styleList;
        this.setData(new ArrayList<String>(this.mData.values()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String styleName = e.getItem().toString();
        if (this.controller != null && styleName != null) {
            for (Map.Entry<Integer, String> item : this.mData.entrySet()) {
                if (!styleName.equals(item.getValue())) continue;
                this.controller.sendAction(item.getKey());
                return;
            }
        }
    }

    private void setData(List<String> osList) {
        if (osList == null) {
            return;
        }
        this.stateBarBox.removeAllItems();
        for (String itemName : osList) {
            this.stateBarBox.addItem(itemName);
        }
    }
}

