/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar.view;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.panel.devicetoolbar.base.IScreenshotView;
import com.immomo.mmpaas.panel.devicetoolbar.view.DeviceToolbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ScreenshotView
implements IScreenshotView,
ItemListener {
    private final JPanel mRootPanel;
    private final Context context;
    private JPanel panel;
    private JComboBox<String> stateBarBox;
    private boolean isCompare;
    private Map<String, String> mData;

    public ScreenshotView(JPanel mRootPanel, Context context2, boolean isCompare) {
        this.mRootPanel = mRootPanel;
        this.context = context2;
        this.isCompare = isCompare;
        this.initView();
    }

    private void initView() {
        this.panel = new JPanel();
        this.panel.setBackground(this.context.getTheme().backgroundColor);
        this.stateBarBox = this.makeNewMenu();
        this.showList();
        this.mRootPanel.add(this.panel);
    }

    private JComboBox<String> makeNewMenu() {
        JComboBox<String> cmb = new JComboBox<String>();
        cmb.addItemListener(this);
        cmb.setRenderer(new mComboRenderer());
        cmb.setUI(new DeviceToolbar.ComboBoxUI());
        cmb.setForeground(this.context.getTheme().textColor);
        cmb.setBackground(this.context.getTheme().backgroundColor);
        cmb.setVisible(true);
        this.panel.add(cmb);
        return cmb;
    }

    @Override
    public void showList() {
        this.mData = new LinkedHashMap<String, String>();
        this.mData.put("BC_SCREENSHOT", this.isCompare ? "-\u56fe\u7247\u5bf9\u6bd4-" : "- \u622a\u56fe -");
        this.mData.put(this.isCompare ? "BC_PIC_COMPARE_BATTERY" : "BC_SCREENSHOT_BATTERY", "\u5e26\u7535\u6c60\u680f");
        this.mData.put(this.isCompare ? "BC_PIC_COMPARE_NOBATTERY" : "BC_SCREENSHOT_NOBATTERY", "\u4e0d\u5e26\u7535\u6c60\u680f");
        this.setData(new ArrayList<String>(this.mData.values()));
    }

    @Override
    public void sendAction(String action) {
        this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_SCREENSHOT", action));
        if (this.stateBarBox.getSelectedIndex() != 0) {
            this.stateBarBox.setSelectedIndex(0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String styleName = e.getItem().toString();
        if (styleName != null) {
            for (Map.Entry<String, String> item : this.mData.entrySet()) {
                if (!styleName.equals(item.getValue()) || "BC_SCREENSHOT".equals(item.getKey())) continue;
                this.sendAction(item.getKey());
                return;
            }
        }
    }

    private void setData(List<String> osList) {
        if (osList == null) {
            return;
        }
        this.stateBarBox.removeAllItems();
        for (String itemName : osList) {
            this.stateBarBox.addItem(itemName);
        }
    }

    public static class mComboRenderer
    implements ListCellRenderer<String> {
        private DefaultListCellRenderer defaultCellRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            Color backgroundColor = Application.getApplicationContext().getTheme().backgroundColor;
            Color textColor = Application.getApplicationContext().getTheme().textColor;
            JLabel labelItem = (JLabel)this.defaultCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            labelItem.setText(value);
            labelItem.setBackground(backgroundColor);
            labelItem.setForeground(textColor);
            list.setSelectionBackground(backgroundColor);
            list.setSelectionForeground(textColor);
            list.setBackground(backgroundColor);
            return labelItem;
        }
    }
}

