/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar.view;

import com.immomo.mmpaas.base.BaseLifeCyclePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.devicetoolbar.bean.ScaleMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ScaleToolView
extends BaseLifeCyclePanel
implements BroadCastReceiver {
    private final JPanel mRootPanel;
    private JButton addBtn;
    private JButton reduceBtn;
    private JLabel label;
    private int scaleValue = 100;
    private final int distance = 10;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ScaleToolView.this.addBtn) {
                ScaleToolView.this.checkAndSend(true);
            } else if (e.getSource() == ScaleToolView.this.reduceBtn) {
                ScaleToolView.this.checkAndSend(false);
            }
        }
    };

    public ScaleToolView(JPanel mRootPanel, Context context2) {
        super(context2);
        this.mRootPanel = mRootPanel;
        this.context = context2;
        this.initView();
        this.setText(this.scaleValue);
        context2.registerReceiver(context2, "BC_SCALE_PHONE_UPDATE", this);
    }

    public void destroy() {
        this.context.unregisterReceiver("BC_SCALE_PHONE_UPDATE", this);
    }

    private void initView() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(this.context.getTheme().backgroundColor);
        this.reduceBtn = new JButton("-");
        this.reduceBtn.setFont(new Font(null, 0, 16));
        this.reduceBtn.setForeground(this.context.getTheme().textColor);
        this.reduceBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.reduceBtn.addMouseListener(this.mouseAdapter);
        this.label = new JLabel();
        this.label.setBackground(this.context.getTheme().backgroundColor);
        this.label.setForeground(this.context.getTheme().propertyInputColor);
        this.label.setFont(new Font(null, 0, this.context.getTheme().propertyInputSize));
        this.label.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.addBtn = new JButton("+");
        this.addBtn.setFont(new Font(null, 0, 16));
        this.addBtn.setForeground(this.context.getTheme().textColor);
        this.addBtn.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.addBtn.addMouseListener(this.mouseAdapter);
        panel.add((Component)this.reduceBtn, "West");
        panel.add((Component)this.label, "Center");
        panel.add((Component)this.addBtn, "East");
        this.mRootPanel.add(panel);
    }

    private void checkAndSend(boolean isAdd) {
        if (isAdd) {
            BroadCastManager.getManager().send(this.context, BroadCastMessage.obtain("BC_RESET_SCALE_UPDATE", new ScaleMessage((float)(this.scaleValue + 10) / 100.0f, 2)));
        } else if (this.scaleValue - 10 >= 0) {
            BroadCastManager.getManager().send(this.context, BroadCastMessage.obtain("BC_RESET_SCALE_UPDATE", new ScaleMessage((float)(this.scaleValue - 10) / 100.0f, 1)));
        }
    }

    private void setText(int value) {
        this.label.setText(String.format("%d%s", value, "%"));
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_SCALE_PHONE_UPDATE": {
                this.scaleValue = (int)(((Float)msg.msg).floatValue() * 100.0f);
                this.setText(this.scaleValue);
            }
        }
        return false;
    }
}

