/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar.view;

import com.immomo.mmpaas.base.BaseLifeCyclePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.panel.devicetoolbar.base.IDeviceToolbarController;
import com.immomo.mmpaas.panel.devicetoolbar.base.IDeviceToolbarView;
import com.immomo.mmpaas.panel.devicetoolbar.bean.DeviceOSData;
import com.immomo.mmpaas.panel.devicetoolbar.bean.VirtualDevice;
import com.immomo.mmpaas.panel.devicetoolbar.controller.DeviceToolbarController;
import com.immomo.mmpaas.panel.devicetoolbar.view.DeviceToolbar;
import com.immomo.mmpaas.utils.Log;
import javax.swing.JPanel;

public class DeviceToolbarView
extends BaseLifeCyclePanel
implements IDeviceToolbarView<DeviceOSData> {
    public static final String TYPE_TOOLBAR_OS = "TYPE_TOOLBAR_OS";
    public static final String TYPE_TOOLBAR_DEVICE = "TYPE_TOOLBAR_DEVICE";
    private JPanel mRootPanel;
    private IDeviceToolbarController controller;
    private DeviceToolbar deviceToolbar;

    public DeviceToolbarView(JPanel mRootPanel, DeviceToolbarController controller, Context context2) {
        super(context2);
        this.mRootPanel = mRootPanel;
        this.controller = controller;
        this.context = context2;
        controller.setView(this);
        this.initView();
        controller.load();
    }

    @Override
    public void initView() {
        this.deviceToolbar = new DeviceToolbar(this.context);
        this.deviceToolbar.setVisible(true);
        this.deviceToolbar.setScaleToolBarItemLisenter(new DeviceToolbar.ScaleToolBarItemLisenter(){

            @Override
            public void itemStateChanged(VirtualDevice virtualDevice) {
                Log.l(virtualDevice.getOs() + " == " + virtualDevice.getName(), new Object[0]);
                if (DeviceToolbarView.this.controller != null) {
                    DeviceToolbarView.this.controller.postAction(virtualDevice);
                }
            }
        });
        this.mRootPanel.add(this.deviceToolbar);
    }

    @Override
    public void show(DeviceOSData data) {
        this.deviceToolbar.setData(data);
    }
}

