/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar.view;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.panel.devicetoolbar.bean.DeviceOSData;
import com.immomo.mmpaas.panel.devicetoolbar.bean.VirtualDevice;
import com.immomo.mmpaas.panel.devicetoolbar.view.DeviceArrowButton;
import com.sun.istack.internal.NotNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class DeviceToolbar
extends JPanel {
    private ScaleToolBarItemLisenter itemListener;
    private JComboBox<String> osBox;
    private JComboBox<String> deviceBox;
    DeviceOSData data;
    private String currentOS;
    private String currentDevice;
    private Context context;
    private boolean isFirst = true;

    public DeviceToolbar(Context context2) {
        super(new FlowLayout());
        this.context = context2;
        this.osBox = this.makeNewMenu("TYPE_TOOLBAR_OS");
        this.deviceBox = this.makeNewMenu("TYPE_TOOLBAR_DEVICE");
        this.setBackground(context2.getTheme().backgroundColor);
    }

    public void setData(DeviceOSData data) {
        this.data = data;
        this.setOSData(data.getOSList());
    }

    private void setOSData(List<String> osList) {
        if (osList == null) {
            return;
        }
        this.osBox.removeAllItems();
        for (String itemName : osList) {
            this.osBox.addItem(itemName);
        }
    }

    private void setDeviceData(List<VirtualDevice> deviceList) {
        if (deviceList == null) {
            return;
        }
        this.deviceBox.removeAllItems();
        for (VirtualDevice itemName : deviceList) {
            this.deviceBox.addItem(itemName.getName());
        }
    }

    private JComboBox<String> makeNewMenu(String type2) {
        JComboBox<String> cmb = new JComboBox<String>();
        cmb.addItemListener(new ToolBarLisenter(type2));
        cmb.setRenderer(new TrueFalseComboRenderer());
        cmb.setUI(new ComboBoxUI());
        cmb.setForeground(this.context.getTheme().textColor);
        cmb.setBackground(this.context.getTheme().backgroundColor);
        cmb.setVisible(true);
        cmb.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.add(cmb);
        return cmb;
    }

    public void setScaleToolBarItemLisenter(ScaleToolBarItemLisenter itemListener) {
        this.itemListener = itemListener;
    }

    public class ToolBarLisenter
    implements ItemListener {
        @NotNull
        private String type;

        public ToolBarLisenter(String type2) {
            this.type = type2;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            if ("TYPE_TOOLBAR_OS".equals(this.type)) {
                DeviceToolbar.this.currentOS = e.getItem().toString();
                DeviceToolbar.this.setDeviceData(DeviceToolbar.this.data.getDeviceList((String)e.getItem()));
                return;
            }
            if (DeviceToolbar.this.isFirst) {
                DeviceToolbar.this.isFirst = false;
                return;
            }
            DeviceToolbar.this.currentDevice = e.getItem().toString();
            VirtualDevice virtualDevice = DeviceToolbar.this.data.getDeviceByName(DeviceToolbar.this.currentOS, DeviceToolbar.this.currentDevice);
            if (DeviceToolbar.this.itemListener != null && virtualDevice != null) {
                DeviceToolbar.this.itemListener.itemStateChanged(virtualDevice);
            }
        }
    }

    public static class TrueFalseComboRenderer
    implements ListCellRenderer<String> {
        private DefaultListCellRenderer defaultCellRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            Color backgroundColor = Application.getApplicationContext().getTheme().backgroundColor;
            Color textColor = Application.getApplicationContext().getTheme().textColor;
            JLabel labelItem = (JLabel)this.defaultCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            labelItem.setText(value);
            labelItem.setBackground(backgroundColor);
            labelItem.setForeground(textColor);
            list.setSelectionBackground(backgroundColor);
            list.setSelectionForeground(textColor);
            list.setBackground(backgroundColor);
            return labelItem;
        }
    }

    public static class ComboBoxUI
    extends BasicComboBoxUI {
        @Override
        protected ComboPopup createPopup() {
            return new BasicComboPopup(this.comboBox);
        }

        @Override
        protected JButton createArrowButton() {
            Color backgroundColor = Application.getApplicationContext().getTheme().backgroundColor;
            Color foreground = Application.getApplicationContext().getTheme().foregroundColor;
            DeviceArrowButton button = new DeviceArrowButton(5, backgroundColor, backgroundColor, foreground, foreground);
            button.setBorder(null);
            return button;
        }
    }

    public static interface ScaleToolBarItemLisenter {
        public void itemStateChanged(VirtualDevice var1);
    }
}

