/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.devicetoolbar;

import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.devicetoolbar.controller.DeviceToolbarController;
import com.immomo.mmpaas.panel.devicetoolbar.controller.StateBarController;
import com.immomo.mmpaas.panel.devicetoolbar.view.DeviceToolbarView;
import com.immomo.mmpaas.panel.devicetoolbar.view.ScaleToolView;
import com.immomo.mmpaas.panel.devicetoolbar.view.ScreenshotView;
import com.immomo.mmpaas.panel.devicetoolbar.view.StateBarView;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.BorderUIResource;

public class DeviceToolbarPanel
extends BasePanel
implements BroadCastReceiver {
    private JPanel panel;
    private JPanel leftPanel;
    private DeviceToolbarView deviceToolbarView;
    private DeviceToolbarController deviceToolbarController;
    private StateBarView stateBarView;
    private StateBarController stateBarController;
    private ScaleToolView scaleToolView;
    private ScreenshotView screenshotView;
    private ScreenshotView picCompareView;

    public DeviceToolbarPanel(Context context2) {
        super(context2);
        this.initView();
        context2.registerReceiver(context2, "BC_MAIN_TAB_SELECTED", this);
    }

    private void initView() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.panel = new JPanel();
        this.panel.setLayout(borderLayout);
        this.panel.setBackground(this.context.getTheme().backgroundColor);
        this.panel.setBorder(new BorderUIResource.LineBorderUIResource(this.context.getTheme().borderColor));
        FlowLayout f = new FlowLayout(0);
        f.setHgap(10);
        f.setVgap(0);
        this.leftPanel = new JPanel(f);
        this.leftPanel.setOpaque(false);
        this.leftPanel.setBackground(this.context.getTheme().backgroundColor);
        this.panel.add((Component)this.leftPanel, "Center");
    }

    @Override
    public void build() {
        if (this.deviceToolbarController == null) {
            this.deviceToolbarController = new DeviceToolbarController(this.context);
        }
        if (this.deviceToolbarView == null) {
            this.deviceToolbarView = new DeviceToolbarView(this.leftPanel, this.deviceToolbarController, this.context);
        }
        if (this.stateBarController == null) {
            this.stateBarController = new StateBarController(this.context);
        }
        if (this.stateBarView == null) {
            this.stateBarView = new StateBarView(this.leftPanel, this.stateBarController, this.context);
        }
        if (this.scaleToolView == null) {
            this.scaleToolView = new ScaleToolView(this.leftPanel, this.context);
        }
        if (this.screenshotView == null) {
            this.screenshotView = new ScreenshotView(this.leftPanel, this.context, false);
        }
        if (this.picCompareView == null) {
            this.picCompareView = new ScreenshotView(this.leftPanel, this.context, true);
        }
        this.registerChildLifeCycle(this.deviceToolbarView);
        this.registerChildLifeCycle(this.stateBarView);
        this.registerChildLifeCycle(this.scaleToolView);
        JLabel issuesLabel = new JLabel();
        issuesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        issuesLabel.setOpaque(true);
        issuesLabel.setBackground(this.context.getTheme().backgroundColor);
        issuesLabel.setIcon(ImageLoader.getInstance().loadProjectImageIcon(P.icons.ic_issues));
        issuesLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceToolbarPanel.this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_MESSAGE_SHOW"));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.panel.add((Component)issuesLabel, "East");
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_MAIN_TAB_SELECTED": {
                int type2 = (Integer)msg.msg;
                if (type2 == 1) {
                    if (this.visible) break;
                    this.visible = true;
                    context2.updatePanel(this);
                    break;
                }
                if (type2 != 2 || !this.visible) break;
                this.visible = false;
                context2.updatePanel(this);
            }
        }
        return false;
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
        if (this.scaleToolView != null) {
            this.scaleToolView.destroy();
        }
    }
}

