/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design.windowtree_panel.view;

import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.design.weight.WindowNodeUserObject;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.panel.design.windowtree_panel.WindowTreePanel;
import com.immomo.mmpaas.panel.design.windowtree_panel.base.IWindowTreeView;
import com.immomo.mmpaas.panel.design.windowtree_panel.base.IWnidowTreeController;
import com.immomo.mmpaas.panel.design.windowtree_panel.view.WIndowTreeUI;
import com.immomo.mmpaas.panel.design.windowtree_panel.view.WindowTreeCellRenderer;
import com.sun.istack.internal.NotNull;
import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WindowTreeView
implements IWindowTreeView,
TreeSelectionListener {
    private final IWnidowTreeController controller;
    @NotNull
    private Context context;
    private final WindowTreePanel mRootPanel;
    private JScrollPane scrollPane;
    private boolean hasInit = false;
    private boolean internal;
    private JComponent label;
    private JTree windowTree;

    public WindowTreeView(@NotNull Context context2, WindowTreePanel panel, IWnidowTreeController controller) {
        this.controller = controller;
        this.context = context2;
        this.mRootPanel = panel;
        controller.setView(this);
        this.initPanel();
    }

    @Override
    public void start(JComponent luaContainer) {
        this.controller.load(luaContainer);
    }

    @Override
    public void selectNode(IView view) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.windowTree.getModel().getRoot();
        this.internal = true;
        WindowTreeView.expandNode(this.windowTree, new TreePath(treeNode), view);
        this.internal = false;
    }

    @Override
    public void initPanel() {
        Theme theme = this.context.getTheme();
        if (!this.hasInit) {
            JPanel rootPanel = (JPanel)this.mRootPanel.getComponent();
            JLabel jLabel = new JLabel("\u89c6\u56fe\u6811");
            this.label = jLabel;
            jLabel.setOpaque(true);
            jLabel.setBorder(new EmptyBorder(3, 3, 3, 3));
            jLabel.setFont(new Font(null, 0, 16));
            this.windowTree = new JTree(new DefaultMutableTreeNode());
            this.windowTree.addKeyListener(null);
            this.windowTree.setUI(new WIndowTreeUI());
            WindowTreeCellRenderer renderer2 = new WindowTreeCellRenderer();
            renderer2.setRootFont(new Font(null, 0, 16));
            renderer2.setChildFont(new Font(null, 0, 12));
            renderer2.setLeafIcon(null);
            renderer2.setClosedIcon(null);
            renderer2.setOpenIcon(null);
            renderer2.setTextSelectionColor(theme.selectTextColor);
            renderer2.setTextNonSelectionColor(theme.textColor);
            renderer2.setBackgroundSelectionColor(theme.transparent);
            renderer2.setBackgroundNonSelectionColor(theme.transparent);
            this.windowTree.setCellRenderer(renderer2);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(null);
            this.scrollPane.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
            this.scrollPane.getHorizontalScrollBar().setUI(new WindowTreeScrollBarUI());
            this.scrollPane.setViewportView(this.windowTree);
            rootPanel.add((Component)jLabel, "North");
            rootPanel.add((Component)this.scrollPane, "Center");
            this.windowTree.addTreeSelectionListener(this);
            this.hasInit = true;
        }
        this.windowTree.setBackground(theme.backgroundColor);
        this.scrollPane.setBackground(theme.backgroundColor);
        this.label.setForeground(theme.textColor);
        this.label.setBackground(theme.backgroundColor);
    }

    @Override
    public void show(DefaultMutableTreeNode treeNode) {
        if (treeNode != null) {
            DefaultTreeModel mode = (DefaultTreeModel)this.windowTree.getModel();
            mode.setRoot(treeNode);
            this.windowTree.setModel(mode);
            WindowTreeView.expandAll(this.windowTree, new TreePath(treeNode), true);
            this.windowTree.revalidate();
        }
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                WindowTreeView.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private static void expandNode(JTree tree, TreePath parent, IView view) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                WindowNodeUserObject userObject = (WindowNodeUserObject)n.getUserObject();
                TreePath path = parent.pathByAddingChild(n);
                if (userObject.getLuaView() == view) {
                    tree.setSelectionPath(path);
                    return;
                }
                WindowTreeView.expandNode(tree, path, view);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.internal) {
            return;
        }
        Object note = this.windowTree.getLastSelectedPathComponent();
        if (note instanceof DefaultMutableTreeNode) {
            this.controller.sendComponent((DefaultMutableTreeNode)note);
        }
    }
}

