/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design.windowtree_panel.view;

import com.immomo.mmpaas.panel.design.windowtree_panel.view.WindowTreeCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WIndowTreeUI
extends BasicTreeUI {
    public static final String TREE_TABLE_TREE_KEY = "TreeTableTree";
    @NonNls
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    @NonNls
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    private static final Logger LOG = Logger.getInstance(WIndowTreeUI.class);
    private static final Set<String> LOGGED_RENDERERS = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Condition<? super Integer> myWideSelectionCondition;
    private final boolean myWideSelection;
    private boolean myOldRepaintAllRowValue;
    private boolean myForceDontPaintLines;
    private static final boolean mySkinny = false;
    private static final TreeUIAction EXPAND_OR_SELECT_NEXT = new TreeUIAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JTree tree;
            TreePath path;
            Object source = event.getSource();
            if (source instanceof JTree && (path = (tree = (JTree)source).getLeadSelectionPath()) != null) {
                if (tree.isExpanded(path) || tree.getModel().isLeaf(path.getLastPathComponent())) {
                    int row = tree.getRowForPath(path);
                    TreePath treePath = path = row < 0 ? null : tree.getPathForRow(row + 1);
                    if (path != null) {
                        tree.setSelectionPath(path);
                        tree.scrollPathToVisible(path);
                    }
                } else {
                    tree.expandPath(path);
                }
            }
        }
    };
    private static final TreeUIAction COLLAPSE_OR_SELECT_PREVIOUS = new TreeUIAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JTree tree;
            TreePath path;
            Object source = event.getSource();
            if (source instanceof JTree && (path = (tree = (JTree)source).getLeadSelectionPath()) != null) {
                if (tree.isExpanded(path)) {
                    tree.collapsePath(path);
                } else {
                    TreePath parent = path.getParentPath();
                    if (parent != null) {
                        if (!tree.isRootVisible() && null == parent.getParentPath()) {
                            int row = tree.getRowForPath(path);
                            TreePath treePath = parent = row < 1 ? null : tree.getPathForRow(row - 1);
                        }
                        if (parent != null) {
                            tree.setSelectionPath(parent);
                            tree.scrollPathToVisible(parent);
                        }
                    }
                }
            }
        }
    };

    public WIndowTreeUI() {
        this(true, (Condition<? super Integer>)Conditions.alwaysTrue());
    }

    public WIndowTreeUI(boolean wideSelection, @NotNull Condition<? super Integer> wideSelectionCondition) {
        if (wideSelectionCondition == null) {
            WIndowTreeUI.$$$reportNull$$$0(0);
        }
        this.myForceDontPaintLines = false;
        this.myWideSelection = wideSelection;
        this.myWideSelectionCondition = wideSelectionCondition;
    }

    @Override
    public int getRightChildIndent() {
        return this.isCustomIndent() ? this.getCustomIndent() : super.getRightChildIndent();
    }

    public boolean isCustomIndent() {
        return this.getCustomIndent() > 0;
    }

    protected int getCustomIndent() {
        return JBUI.scale((int)Registry.intValue((String)"ide.ui.tree.indent"));
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            public void mouseDragged(MouseEvent event) {
                JTree tree = (JTree)event.getSource();
                Object property = tree.getClientProperty("DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event)) {
                    Rectangle bounds;
                    TreePath path;
                    int x = event.getX();
                    int y = event.getY();
                    JTree tree = (JTree)event.getSource();
                    if (tree.isEnabled() && (path = WIndowTreeUI.this.getClosestPathForLocation(tree, x, y)) != null && !WIndowTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = WIndowTreeUI.this.getPathBounds(tree, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                        event = 3.convert((MouseEvent)event, (Component)tree, (int)x, (int)y);
                    }
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/immomo/mmpaas/panel/design/windowtree_panel/view/WIndowTreeUI$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/immomo/mmpaas/panel/design/windowtree_panel/view/WIndowTreeUI$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap map = this.tree.getActionMap();
        map.put("selectChild", EXPAND_OR_SELECT_NEXT);
        map.put("selectParent", COLLAPSE_OR_SELECT_PREVIOUS);
    }

    public void setForceDontPaintLines() {
        this.myForceDontPaintLines = true;
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isCustomIndent()) {
            int off = this.tree.isRootVisible() ? 8 : 0;
            return 8 * depth + 8 + off;
        }
        return super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.shouldPaintLines()) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private boolean shouldPaintLines() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return false;
        }
        return this.myForceDontPaintLines || !"None".equals(this.tree.getClientProperty("JTree.lineStyle"));
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return UIUtil.isToggleListSelectionEvent((MouseEvent)e);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.shouldPaintLines()) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.shouldPaintLines()) {
            super.paintVerticalLine(g, c, x, top, bottom);
        }
    }

    public boolean isWideSelection() {
        return this.myWideSelection;
    }

    public static boolean isWideSelection(@NotNull JTree tree) {
        TreeUI ui;
        if (tree == null) {
            WIndowTreeUI.$$$reportNull$$$0(1);
        }
        return (ui = tree.getUI()) instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)ui).isWideSelection();
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        this.checkRootFont(row);
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null && this.myWideSelection) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = this.tree.getBackground();
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected && (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
                Color bg = WIndowTreeUI.getSelectionBackground(this.tree, true);
                if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myWideSelection && !UIUtil.isUnderAquaBasedLookAndFeel() && !UIUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF()) {
            this.paintSelectedRows(g, (JTree)c);
        }
        if (this.myWideSelection) {
            int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
            int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
            Rectangle bounds = g.getClipBounds();
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                Graphics2D backgroundGraphics = (Graphics2D)g.create();
                backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
                LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                backgroundGraphics.dispose();
            }
        }
        super.paint(g, c);
    }

    protected void paintSelectedRows(Graphics g, JTree tr) {
        Rectangle rect = tr.getVisibleRect();
        int firstVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            if (!tr.getSelectionModel().isRowSelected(row) || !this.myWideSelectionCondition.value((Object)row)) continue;
            Rectangle bounds = tr.getRowBounds(row);
            Color color = WIndowTreeUI.getSelectionBackground(tr, false);
            if (color == null) continue;
            g.setColor(color);
            g.fillRect(0, bounds.y, tr.getWidth(), bounds.height);
        }
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new WindowNodeDimensionsHandler();
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                TreeCellRenderer renderer2 = WIndowTreeUI.this.currentCellRenderer;
                if (c != null && renderer2 != null && LOG.isDebugEnabled()) {
                    Class<?> type2;
                    Method method = ReflectionUtil.getMethod(c.getClass(), (String)"validate", (Class[])new Class[0]);
                    Class<?> clazz = type2 = method == null ? null : method.getDeclaringClass();
                    if (Component.class.equals(type2) || Container.class.equals(type2)) {
                        String name = renderer2.getClass().getName();
                        if (LOGGED_RENDERERS.add(name)) {
                            LOG.debug("suspicious renderer: " + name);
                        }
                    }
                }
                if (c instanceof JComponent && WIndowTreeUI.this.myWideSelection && c.isOpaque()) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        if (!this.isLeaf(row)) {
            this.setExpandedIcon(this.getTreeNodeIcon(true, isPathSelected, this.tree.hasFocus()));
            this.setCollapsedIcon(this.getTreeNodeIcon(false, isPathSelected, this.tree.hasFocus()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Nullable
    private static Color getSelectionBackground(@NotNull JTree tree, boolean checkProperty) {
        Object property;
        if (tree == null) {
            WIndowTreeUI.$$$reportNull$$$0(2);
        }
        if ((property = tree.getClientProperty(TREE_TABLE_TREE_KEY)) instanceof JTable) {
            return ((JTable)property).getSelectionBackground();
        }
        boolean selection = tree.hasFocus();
        if (!selection && checkProperty) {
            selection = Boolean.TRUE.equals(property);
        }
        return UIUtil.getTreeSelectionBackground((boolean)selection);
    }

    public void invalidateNodeSizes() {
        this.treeState.invalidateSizes();
    }

    public Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || UIUtil.isUnderDarcula();
        Icon selectedIcon = this.getTreeSelectedExpandedIcon();
        Icon notSelectedIcon = this.getTreeExpandedIcon();
        int width = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        int height = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        return new CenteredIcon(expanded ? (white ? this.getTreeSelectedExpandedIcon() : this.getTreeExpandedIcon()) : (white ? this.getTreeSelectedCollapsedIcon() : this.getTreeCollapsedIcon()), width, height, false);
    }

    private Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    private Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    private Icon getTreeSelectedCollapsedIcon() {
        return this.getTreeCollapsedIcon();
    }

    private Icon getTreeSelectedExpandedIcon() {
        return this.getTreeExpandedIcon();
    }

    private void checkRootFont(int row) {
        if (this.currentCellRenderer instanceof WindowTreeCellRenderer) {
            if (row == 0) {
                ((WindowTreeCellRenderer)this.currentCellRenderer).setFont(((WindowTreeCellRenderer)this.currentCellRenderer).getWindowFont());
            } else {
                ((WindowTreeCellRenderer)this.currentCellRenderer).setFont(((WindowTreeCellRenderer)this.currentCellRenderer).getChildFont());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideSelectionCondition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/immomo/mmpaas/panel/design/windowtree_panel/view/WIndowTreeUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWideSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class WindowNodeDimensionsHandler
    extends BasicTreeUI.NodeDimensionsHandler {
        private WindowNodeDimensionsHandler() {
            super(WIndowTreeUI.this);
        }

        @Override
        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            if (WIndowTreeUI.this.editingComponent != null && WIndowTreeUI.this.editingRow == row) {
                Dimension prefSize = WIndowTreeUI.this.editingComponent.getPreferredSize();
                int rh = WIndowTreeUI.this.getRowHeight();
                if (rh > 0 && rh != prefSize.height) {
                    prefSize.height = rh;
                }
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            if (WIndowTreeUI.this.currentCellRenderer != null) {
                WIndowTreeUI.this.checkRootFont(row);
                Component aComponent = WIndowTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(WIndowTreeUI.this.tree, value, WIndowTreeUI.this.tree.isRowSelected(row), expanded, WIndowTreeUI.this.treeModel.isLeaf(value), row, false);
                if (WIndowTreeUI.this.tree != null) {
                    WIndowTreeUI.this.rendererPane.add(aComponent);
                    aComponent.validate();
                }
                Dimension prefSize = aComponent.getPreferredSize();
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            return null;
        }
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

