/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design.windowtree_panel.model;

import com.immomo.mlservics.luaview.LuaWindow;
import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.panel.design.weight.WindowNodeUserObject;
import com.immomo.mmpaas.panel.design.windowtree_panel.base.IWindowTreeModel;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class WindowTreeRepository
implements IWindowTreeModel {
    @Override
    public DefaultMutableTreeNode load(JComponent luaContainer) {
        LuaWindow luaWindow = this.findLuaWindow(luaContainer);
        DefaultMutableTreeNode luawindowNode = new DefaultMutableTreeNode(new WindowNodeUserObject(luaWindow, "window"));
        this.setNodes(luaWindow, luawindowNode);
        return luawindowNode;
    }

    public void setNodes(Container luaWindow, DefaultMutableTreeNode luawindowNode) {
        if (luaWindow == null) {
            return;
        }
        Component[] luaIViewList = luaWindow.getComponents();
        for (int i = 0; i < luaIViewList.length; ++i) {
            Component component = luaIViewList[i];
            if (!(component instanceof IView)) continue;
            IView iView = (IView)((Object)component);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new WindowNodeUserObject(iView, iView.getLuaClassName()));
            luawindowNode.add(childNode);
            if (!(component instanceof Container)) continue;
            this.setNodes((Container)component, childNode);
        }
    }

    private LuaWindow findLuaWindow(JComponent windowRoot) {
        Component[] comps = windowRoot.getComponents();
        if (comps == null) {
            return null;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof LuaWindow)) continue;
            return (LuaWindow)comps[i];
        }
        return null;
    }
}

