/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design.windowtree_panel;

import com.immomo.mlservics.weight.interfaces.IView;
import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.windowtree_panel.base.IWindowTreeView;
import com.immomo.mmpaas.panel.design.windowtree_panel.base.IWnidowTreeController;
import com.immomo.mmpaas.panel.design.windowtree_panel.controller.WindowTreeController;
import com.immomo.mmpaas.panel.design.windowtree_panel.model.WindowTreeRepository;
import com.immomo.mmpaas.panel.design.windowtree_panel.view.WindowTreeView;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WindowTreePanel
extends BasePanel
implements BroadCastReceiver {
    private JPanel panel;
    private IWnidowTreeController controller;
    private IWindowTreeView windowTreeView;

    public WindowTreePanel(Context context2) {
        super(context2);
        this.visible = true;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(1, 1));
        context2.registerReceiver(context2, "BC_WINDOW_TREE_UPDATE", this);
        context2.registerReceiver(context2, "BC_PHONE_TOUCH_CLICK", this);
        this.init();
    }

    private void init() {
        this.controller = new WindowTreeController(new WindowTreeRepository());
        this.windowTreeView = new WindowTreeView(this.context, this, this.controller);
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_WINDOW_TREE_UPDATE", this);
        this.context.unregisterReceiver("BC_PHONE_TOUCH_CLICK", this);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_WINDOW_TREE_UPDATE": {
                this.visible = true;
                JComponent component = (JComponent)msg.msg;
                context2.updatePanel(this);
                this.windowTreeView.start(component);
                break;
            }
            case "BC_PHONE_TOUCH_CLICK": {
                if (!(msg.msg instanceof IView)) break;
                this.windowTreeView.selectNode((IView)msg.msg);
            }
        }
        return false;
    }
}

