/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design.components_panel.view;

import com.immomo.mlservics.Register;
import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.Theme;
import com.immomo.mmpaas.panel.design.components_panel.base.IComponentsController;
import com.immomo.mmpaas.panel.design.components_panel.base.IComponentsView;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.ComponentDragHelper;
import com.immomo.mmpaas.panel.design.components_panel.dragapi.source.DragGestureHandler;
import com.immomo.mmpaas.panel.design.components_panel.view.CompListPanel;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.utils.ImageLoader;
import com.immomo.mmpaas.utils.P;
import com.intellij.ui.components.JBBox;
import com.sun.istack.internal.NotNull;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ComponentsView
implements IComponentsView {
    private final IComponentsController controller;
    @NotNull
    private Context context;
    private final BasePanel mRootPanel;
    private JScrollPane scrollPane;
    private JTextField searchBar;
    private CompListPanel componentListView;

    public ComponentsView(@NotNull Context context2, BasePanel panel, IComponentsController controller) {
        this.controller = controller;
        this.context = context2;
        this.mRootPanel = panel;
        controller.setView(this);
        this.start();
    }

    public void start() {
        this.initPanel();
        this.controller.load();
    }

    @Override
    public void initPanel() {
        Theme theme = this.context.getTheme();
        JPanel rootPanel = (JPanel)this.mRootPanel.getComponent();
        rootPanel.setBackground(theme.backgroundColor);
        JBBox panel = JBBox.createHorizontalBox();
        panel.setBorder((Border)new LineBorder(theme.lightBackgroundColor, 4));
        panel.setBackground(theme.backgroundColor);
        JLabel jLabel = new JLabel();
        jLabel.setBackground(theme.backgroundColor);
        jLabel.setForeground(theme.backgroundColor);
        jLabel.setIcon(new ImageIcon(ImageLoader.getInstance().loadProjectImage(P.icons.search).getScaledInstance(20, 20, 1)));
        this.searchBar = new JTextField("search");
        this.searchBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ComponentsView.this.searchBar.getText().equals("search")) {
                    ComponentsView.this.searchBar.setText("");
                }
            }
        });
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentsView.this.controller.filterData(ComponentsView.this.searchBar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ComponentsView.this.controller.filterData(ComponentsView.this.searchBar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ComponentsView.this.controller.filterData(ComponentsView.this.searchBar.getText());
            }
        });
        this.searchBar.setFont(new Font("\u6977\u4f53", 1, 14));
        this.searchBar.setBackground(theme.backgroundColor);
        this.searchBar.setCaretColor(theme.textColor);
        this.searchBar.setForeground(theme.textColor);
        this.searchBar.setBorder(null);
        this.componentListView = new CompListPanel(this.mRootPanel);
        this.componentListView.setBorder(null);
        this.componentListView.setBackground(theme.backgroundColor);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.componentListView);
        panel.add((Component)jLabel);
        panel.add((Component)this.searchBar);
        rootPanel.add((Component)panel, "North");
        rootPanel.add((Component)this.scrollPane, "Center");
        ComponentDragHelper.setDragSource(this.componentListView, new DragGestureHandler(this.componentListView));
    }

    @Override
    public void show(List<Register.UDHolder> treeNode) {
        this.componentListView.showData(treeNode);
    }
}

