/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.design;

import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.IPanel;
import com.immomo.mmpaas.base.IPanelContainer;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.components_panel.ComponentsPanel;
import com.immomo.mmpaas.panel.design.windowtree_panel.WindowTreePanel;
import com.intellij.ui.JBSplitter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class DesignPanel
extends BasePanel
implements BroadCastReceiver,
IPanelContainer {
    private JBSplitter jbSplitter;
    private WindowTreePanel windowTreePanel;
    private ComponentsPanel componentsPanel;
    private int spacing = 2;
    private List<IPanel> children = new ArrayList<IPanel>(2);

    public DesignPanel(Context context2) {
        super(context2);
        this.jbSplitter = new JBSplitter(true, 0.5f, 0.1f, 0.99f);
        this.jbSplitter.setDividerWidth(4);
        this.jbSplitter.getDivider().setBackground(context2.getTheme().borderColor);
        context2.registerReceiver(context2, "BC_MAIN_TAB_SELECTED", this);
    }

    @Override
    public void build() {
        this.children.clear();
        this.windowTreePanel = new WindowTreePanel(this.context);
        this.componentsPanel = new ComponentsPanel(this.context);
        this.componentsPanel.build();
        this.initPanel(this.windowTreePanel, this.jbSplitter);
        this.initPanel(this.componentsPanel, this.jbSplitter);
        this.jbSplitter.setFirstComponent(this.windowTreePanel.getComponent());
        this.jbSplitter.setSecondComponent(this.componentsPanel.getComponent());
        this.registerChildLifeCycle(this.windowTreePanel);
        this.registerChildLifeCycle(this.componentsPanel);
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
        if (this.windowTreePanel != null) {
            this.windowTreePanel.destroy();
        }
    }

    private void initPanel(BasePanel panel, JBSplitter root) {
        JComponent component = panel.getComponent();
        component.setPreferredSize(root.getPreferredSize());
        component.setVisible(panel.visible());
        this.children.add(panel);
    }

    @Override
    public JComponent getComponent() {
        return this.jbSplitter;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        Object data = msg.msg;
        switch (msg.key) {
            case "BC_MAIN_TAB_SELECTED": {
                int type2 = (Integer)data;
                if (type2 == 1) {
                    if (this.visible) break;
                    this.visible = true;
                    context2.updatePanel(this);
                    break;
                }
                if (type2 != 2 || !this.visible) break;
                this.visible = false;
                context2.updatePanel(this);
            }
        }
        return false;
    }

    @Override
    public List<IPanel> getChildren() {
        return this.children;
    }
}

