/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.main;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.IPanel;
import com.immomo.mmpaas.base.IPanelContainer;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.base.broadcast.BroadCastReceiver;
import com.immomo.mmpaas.panel.design.DesignPanel;
import com.immomo.mmpaas.panel.editor.EditorFeildPanel;
import com.immomo.mmpaas.panel.maintab.MainTabPanel;
import com.immomo.mmpaas.panel.property_panel.PropertyPanel;
import com.immomo.mmpaas.panel.virtual.PhonePanel;
import com.immomo.mmpaas.utils.CurrentPathUtils;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MainBasePanel
extends BasePanel
implements IPanelContainer,
BroadCastReceiver {
    private final Context context;
    private final boolean isPluginj;
    private Splitter leftSplitter;
    private Splitter rightSplitter;
    private JPanel panel;
    private JPanel notPluginContainer;
    private MainTabPanel mainTabView;
    private DesignPanel designPanel;
    private PhonePanel phonePanel;
    private EditorFeildPanel editorFeildPanel;
    private PropertyPanel propertyPanel;
    private boolean canEdit;
    private List<IPanel> children = new ArrayList<IPanel>(6);
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MainBasePanel.this.phonePanel != null && (e.getSource() == MainBasePanel.this.leftSplitter.getDivider() || e.getSource() == MainBasePanel.this.rightSplitter.getDivider())) {
                MainBasePanel.this.phonePanel.forceReload();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    };

    public MainBasePanel(Context context2, boolean canEdit) {
        super(context2);
        this.canEdit = canEdit;
        this.isPluginj = Application.getApp().isPlugin();
        this.context = context2;
        this.panel = new JBPanel((LayoutManager)new BorderLayout());
        if (!this.isPluginj) {
            this.width = 1300;
            this.height = 875;
            this.build();
            String luaFilePath = new File(CurrentPathUtils.getCopySourceFile("main.lua")).getAbsolutePath();
            this.setFilePath(luaFilePath, null);
            context2.registerReceiver(context2, "BC_MAIN_TAB_SELECTED", this);
        }
    }

    @Override
    public void build() {
        this.initPanel();
        this.initChildPanel();
    }

    @Override
    public void destroy() {
        if (this.phonePanel != null) {
            this.phonePanel.destroy();
        }
        if (this.mainTabView != null) {
            this.mainTabView.destroy();
        }
        if (this.designPanel != null) {
            this.designPanel.destroy();
        }
        if (this.editorFeildPanel != null) {
            this.editorFeildPanel.destroy();
        }
        if (this.propertyPanel != null) {
            this.propertyPanel.destroy();
        }
        if (!this.isPluginj) {
            this.context.unregisterReceiver("BC_MAIN_TAB_SELECTED", this);
        }
    }

    private void initPanel() {
        this.leftSplitter = new JBSplitter(false, 0.2f, 0.05f, 0.95f);
        this.leftSplitter.setDividerWidth(4);
        this.leftSplitter.getDivider().setBackground(this.context.getTheme().backgroundColor);
        this.leftSplitter.getDivider().addMouseListener(this.mouseAdapter);
        this.rightSplitter = new JBSplitter(false, 0.79f, 0.05f, 0.79f);
        this.rightSplitter.setFirstComponent((JComponent)this.leftSplitter);
        this.rightSplitter.setDividerWidth(4);
        this.rightSplitter.getDivider().setBackground(this.context.getTheme().backgroundColor);
        this.rightSplitter.getDivider().addMouseListener(this.mouseAdapter);
        if (!this.isPluginj) {
            this.notPluginContainer = new JPanel(new BorderLayout());
            this.panel.add((Component)this.notPluginContainer, "Center");
        } else {
            ((JBSplitter)this.leftSplitter).setSplitterProportionKey("SplitFileEditor.Proportion");
            this.panel.add((Component)this.rightSplitter, "Center");
        }
    }

    private void initChildPanel() {
        int realHeight = this.context.getHeight();
        this.children.clear();
        if (this.canEdit) {
            this.designPanel = new DesignPanel(this.context);
            this.leftSplitter.setFirstComponent(this.designPanel.getComponent());
            this.designPanel.build();
            this.updatePanel(this.designPanel);
            this.propertyPanel = new PropertyPanel(this.context);
            this.propertyPanel.build();
            this.rightSplitter.setSecondComponent(this.propertyPanel.getComponent());
            this.updatePanel(this.propertyPanel);
        }
        this.phonePanel = new PhonePanel(this.context, this.canEdit);
        this.phonePanel.build();
        this.leftSplitter.setSecondComponent(this.phonePanel.getComponent());
        this.updatePanel(this.phonePanel);
        if (!this.isPluginj) {
            this.mainTabView = new MainTabPanel(this.context);
            this.mainTabView.getComponent().setPreferredSize(new Dimension(this.mainTabView.getWidth(), this.mainTabView.getHeight()));
            this.mainTabView.build();
            this.panel.add((Component)this.mainTabView.getComponent(), "South");
            this.updatePanel(this.mainTabView);
            this.editorFeildPanel = new EditorFeildPanel(this.context);
            this.editorFeildPanel.setSize(0, 0, this.getWidth(), this.height - this.mainTabView.getHeight());
            this.editorFeildPanel.build();
            this.updatePanel(this.editorFeildPanel);
        }
        this.registerChildLifeCycle(this.designPanel);
        this.registerChildLifeCycle(this.phonePanel);
        this.registerChildLifeCycle(this.propertyPanel);
        this.registerChildLifeCycle(this.mainTabView);
        this.registerChildLifeCycle(this.editorFeildPanel);
        this.panel.addMouseListener(this.mouseAdapter);
    }

    public void setFilePath(String filePath, VirtualFile file) {
        if (this.phonePanel != null) {
            this.phonePanel.setFilePath(filePath, file);
        }
    }

    public void updatePanel(IPanel panel) {
        this.children.add(panel);
    }

    @Override
    public List<IPanel> getChildren() {
        return this.children;
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean onReceive(Context context2, BroadCastMessage msg) {
        if (!this.isResume) {
            return false;
        }
        switch (msg.key) {
            case "BC_MAIN_TAB_SELECTED": {
                if (this.isPluginj) break;
                int type2 = (Integer)msg.msg;
                if (type2 == 2) {
                    this.notPluginContainer.add((Component)this.editorFeildPanel.getComponent(), "Center");
                    break;
                }
                if (type2 != 1) break;
                this.notPluginContainer.add((Component)this.rightSplitter, "Center");
            }
        }
        return false;
    }
}

