/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose.view;

import com.immomo.mmpaas.colorChoose.view.ColorPanel;
import com.immomo.mmpaas.colorChoose.view.ValueFormatter;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlidingSpinner
implements ChangeListener {
    private final ColorPanel panel;
    private final JComponent label;
    private final SpinnerNumberModel model = new SpinnerNumberModel();
    private final JSpinner spinner = new JSpinner(this.model);
    private float value;
    private boolean internal;
    private int min;
    private int max;
    private boolean isRGB = false;

    public SlidingSpinner(ColorPanel panel, JComponent label2) {
        this.panel = panel;
        this.label = label2;
        this.spinner.addChangeListener(this);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        ValueFormatter.init(3, false, editor.getTextField());
        editor.setFocusable(false);
        this.spinner.setFocusable(false);
    }

    public void setRGB(boolean RGB) {
        this.isRGB = RGB;
    }

    JComponent getLabel() {
        return this.label;
    }

    JSpinner getSpinner() {
        return this.spinner;
    }

    float getValue() {
        return this.value;
    }

    void setValue(float value) {
        this.internal = true;
        this.spinner.setValue(this.min + (int)(value * (float)(this.max - this.min)));
        this.internal = false;
        this.value = value;
    }

    void setRange(int min2, int max2) {
        this.internal = true;
        this.min = min2;
        this.max = max2;
        this.model.setMinimum(Integer.valueOf(min2));
        this.model.setMaximum(Integer.valueOf(max2));
        this.internal = false;
    }

    void setVisible(boolean visible) {
        this.label.setVisible(visible);
        this.spinner.setVisible(visible);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (!this.internal) {
            Object value;
            if (this.spinner == event.getSource() && (value = this.spinner.getValue()) instanceof Integer) {
                this.value = (float)((Integer)value - this.min) / (float)(this.max - this.min);
            }
            this.panel.colorChanged(this.isRGB);
        }
    }
}

