/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose.view;

import com.immomo.mmpaas.colorChoose.view.ColorPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class DiagramComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private final ColorPanel panel;
    private final boolean diagram;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private int width;
    private int height;
    private int[] array;
    private BufferedImage image;

    public DiagramComponent(ColorPanel panel, boolean diagram, MouseAdapter mouseAdapter) {
        this.panel = panel;
        this.diagram = diagram;
        this.addMouseListener(this);
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean update;
        this.getInsets(this.insets);
        this.width = this.getWidth() - this.insets.left - this.insets.right;
        this.height = this.getHeight() - this.insets.top - this.insets.bottom;
        boolean bl = update = this.image == null || this.width != this.image.getWidth() || this.height != this.image.getHeight();
        if (update) {
            int size = this.width * this.height;
            if (this.array == null || this.array.length < size) {
                this.array = new int[size];
            }
            this.image = new BufferedImage(this.width, this.height, 1);
        }
        float dx = 1.0f / (float)(this.width - 1);
        float dy = 1.0f / (float)(this.height - 1);
        int offset = 0;
        float y = 0.0f;
        int h = 0;
        while (h < this.height) {
            int w;
            float x = 0.0f;
            if (this.diagram) {
                w = 0;
                while (w < this.width) {
                    this.array[offset] = this.panel.getColor(x, y);
                    ++w;
                    x += dx;
                    ++offset;
                }
            } else {
                w = 0;
                while (w < this.width) {
                    int color;
                    this.array[offset] = color = this.panel.getColor(x);
                    ++w;
                    x += dx;
                    ++offset;
                }
            }
            ++h;
            y += dy;
        }
        this.image.setRGB(0, 0, this.width, this.height, this.array, 0, this.width);
        g.drawImage(this.image, this.insets.left, this.insets.top, this.width, this.height, this);
        if (this.isEnabled()) {
            --this.width;
            --this.height;
            g.setXORMode(Color.WHITE);
            g.setColor(Color.BLACK);
            if (this.diagram) {
                int x = DiagramComponent.getValue(this.panel.getValueX(), this.insets.left, this.width);
                int y2 = DiagramComponent.getValue(this.panel.getValueY(), this.insets.top, this.height);
                g.drawLine(x - 8, y2, x + 8, y2);
                g.drawLine(x, y2 - 8, x, y2 + 8);
            } else {
                int x = DiagramComponent.getValue(this.panel.getValueZ(), this.insets.left, this.width);
                g.drawLine(x, this.insets.top, x, this.insets.top + this.height);
            }
            g.setPaintMode();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mouseDragged(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.isEnabled()) {
            float y = DiagramComponent.getValue(event.getY(), this.insets.top, this.height);
            if (this.diagram) {
                float x = DiagramComponent.getValue(event.getX(), this.insets.left, this.width);
                this.panel.setValue(x, y);
            } else {
                float w = DiagramComponent.getValue(event.getX(), this.insets.left, this.width);
                this.panel.setValue(w);
            }
        }
    }

    private static int getValue(float value, int min2, int max2) {
        return min2 + (int)(value * (float)max2);
    }

    private static float getValue(int value, int min2, int max2) {
        if (min2 < value) {
            return (value -= min2) < max2 ? (float)value / (float)max2 : 1.0f;
        }
        return 0.0f;
    }
}

