/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose.view;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.colorChoose.ColorChooserPanelX;
import com.immomo.mmpaas.colorChoose.ColorModelImple;
import com.immomo.mmpaas.colorChoose.view.SlidingSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.border.Border;

public class ColorPanel
extends JPanel {
    private final SlidingSpinner[] spinners = new SlidingSpinner[7];
    private final float[] values = new float[this.spinners.length];
    private final float[] valuesHSV = new float[this.spinners.length];
    private final ColorModelImple model;
    private Color color;
    private int x = 1;
    private int y = 2;
    private int z;
    private int r = 4;
    private int g = 5;
    private int b = 6;

    public ColorPanel(ColorModelImple model) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.gridy = 1;
        gbc.insets.left = 5;
        Border border = null;
        for (int i = 0; i < this.spinners.length; ++i) {
            JLabel label2 = new JLabel();
            label2.setForeground(Application.getApplicationContext().getTheme().textColor);
            this.add((Component)label2, gbc);
            label2.setBorder(border);
            label2.setFocusable(false);
            this.spinners[i] = new SlidingSpinner(this, label2);
            if (i > model.getRGBIndex()) {
                this.spinners[i].setRGB(true);
            }
            if (i >= 3) continue;
            this.spinners[i].setVisible(false);
        }
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets.top = 0;
        for (SlidingSpinner spinner : this.spinners) {
            this.add((Component)spinner.getSpinner(), gbc);
            gbc.insets.top = 5;
        }
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusable(false);
        this.model = model;
    }

    public void buildPanel() {
        int count = this.model.getCount();
        for (int i = 0; i < count; ++i) {
            String text = this.model.getLabel(this, i);
            JComponent object = this.spinners[i].getLabel();
            if (object instanceof JLabel) {
                JLabel label2 = (JLabel)object;
                label2.setText(text);
            }
            if (i > this.model.getRGBIndex()) {
                this.spinners[i].setRange(this.model.getMinimum(i), this.model.getRGBMaximum(i));
            } else {
                this.spinners[i].setRange(this.model.getMinimum(i), this.model.getMaximum(i));
            }
            this.spinners[i].setValue(this.values[i]);
            this.spinners[i].getSpinner().getAccessibleContext().setAccessibleName(text);
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinners[i].getSpinner().getEditor();
            editor.getTextField().getAccessibleContext().setAccessibleName(text);
            this.spinners[i].getSpinner().getAccessibleContext().setAccessibleDescription(text);
            editor.getTextField().getAccessibleContext().setAccessibleDescription(text);
        }
    }

    void colorChanged(boolean isRGB) {
        int colorInt;
        if (isRGB) {
            colorInt = this.getColor(4);
            this.parseHSVspinner();
        } else {
            colorInt = this.getColor(0);
            this.parseRGBspinner();
        }
        this.color = new Color(colorInt, true);
        Container parent = this.getParent();
        if (parent instanceof ColorChooserPanelX) {
            ColorChooserPanelX chooser = (ColorChooserPanelX)parent;
            chooser.setSelectedColor(this.color);
            chooser.repaint();
        }
    }

    void parseRGBspinner() {
        this.spinners[this.r].setValue(this.values[4]);
        this.spinners[this.g].setValue(this.values[5]);
        this.spinners[this.b].setValue(this.values[6]);
    }

    void parseHSVspinner() {
        this.spinners[this.x].setValue(this.values[this.x]);
        this.spinners[this.y].setValue(this.values[this.y]);
        this.spinners[this.z].setValue(this.values[this.z]);
    }

    float getValueX() {
        return this.spinners[this.x].getValue();
    }

    float getValueY() {
        return 1.0f - this.spinners[this.y].getValue();
    }

    float getValueZ() {
        return 1.0f - this.spinners[this.z].getValue();
    }

    public void setValue(float z) {
        this.spinners[this.z].setValue(1.0f - z);
        this.colorChanged(false);
    }

    public void setValue(float x, float y) {
        this.spinners[this.x].setValue(x);
        this.spinners[this.y].setValue(1.0f - y);
        this.colorChanged(false);
    }

    public int getColor(float z) {
        this.setDefaultValue(this.x);
        this.setDefaultValue(this.y);
        this.values[this.z] = 1.0f - z;
        return this.getColor(3);
    }

    public int getColor(float x, float y) {
        this.values[this.x] = x;
        this.values[this.y] = 1.0f - y;
        this.setValue(this.z);
        return this.getColor(3);
    }

    public void setColor(Color color) {
        if (!color.equals(this.color)) {
            this.color = color;
            this.model.setColor(color.getRGB(), this.values);
            for (int i = 0; i < this.model.getCount(); ++i) {
                this.spinners[i].setValue(this.values[i]);
            }
        }
    }

    private int getColor(int index) {
        if (index == 3) {
            this.setValue(3);
        } else if (index == 0) {
            while (index < this.model.getCount() - 3) {
                this.setValue(index++);
            }
        } else if (index == 4) {
            --index;
            while (index < this.model.getCount()) {
                this.setValue(index++);
            }
            return this.model.getRGBColor(this.values);
        }
        return this.model.getColor(this.values);
    }

    private void setValue(int index) {
        this.values[index] = this.spinners[index].getValue();
    }

    private void setDefaultValue(int index) {
        float value = this.model.getDefault(index);
        this.values[index] = value < 0.0f ? this.spinners[index].getValue() : value;
    }
}

