/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose.utils;

import java.awt.Color;

public class ColorUtil {
    public static String toHexString(Color color, boolean useDouble) {
        if (color == null) {
            return "";
        }
        int a = color.getAlpha();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (a < 255) {
            return String.format("#%s%s%s%s", ColorUtil.toHexString(a, useDouble), ColorUtil.toHexString(r, useDouble), ColorUtil.toHexString(g, useDouble), ColorUtil.toHexString(b, useDouble));
        }
        return String.format("#%s%s%s", ColorUtil.toHexString(r, useDouble), ColorUtil.toHexString(g, useDouble), ColorUtil.toHexString(b, useDouble));
    }

    public static Color toColorInt(String hexString) {
        if (!hexString.startsWith("#")) {
            return null;
        }
        boolean isValid = false;
        int a = 255;
        int r = 255;
        int g = 255;
        int b = 255;
        switch (hexString.length()) {
            case 4: {
                r = Integer.valueOf(hexString.substring(1, 2), 16);
                g = Integer.valueOf(hexString.substring(2, 3), 16);
                b = Integer.valueOf(hexString.substring(3, 4), 16);
                isValid = true;
                break;
            }
            case 5: {
                a = Integer.valueOf(hexString.substring(1, 2), 16);
                r = Integer.valueOf(hexString.substring(2, 3), 16);
                g = Integer.valueOf(hexString.substring(3, 4), 16);
                b = Integer.valueOf(hexString.substring(4, 5), 16);
                isValid = true;
                break;
            }
            case 7: {
                r = Integer.valueOf(hexString.substring(1, 3), 16);
                g = Integer.valueOf(hexString.substring(3, 5), 16);
                b = Integer.valueOf(hexString.substring(5, 7), 16);
                isValid = true;
                break;
            }
            case 9: {
                a = Integer.valueOf(hexString.substring(1, 3), 16);
                r = Integer.valueOf(hexString.substring(3, 5), 16);
                g = Integer.valueOf(hexString.substring(5, 7), 16);
                b = Integer.valueOf(hexString.substring(7, 9), 16);
                isValid = true;
            }
        }
        if (isValid) {
            return new Color(r, g, b, a);
        }
        return null;
    }

    public static boolean isEnableColor(String hexString) {
        int lenght;
        return hexString != null && hexString.startsWith("#") && ((lenght = hexString.length()) == 4 || lenght == 5 || lenght == 7 || lenght == 9);
    }

    private static String toHexString(int value, boolean useDouble) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() == 1 && useDouble) {
            hexString = String.format("0%s", hexString);
        }
        return hexString;
    }
}

