/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose;

import com.immomo.mmpaas.colorChoose.ColorModel;

public class ColorModelImple
extends ColorModel {
    public ColorModelImple() {
        super("rgb", "Hue", "Saturation", "Value", "Alpha", "Red", "Green", "Blue");
    }

    public int getRGBIndex() {
        return 2;
    }

    @Override
    public void setColor(int color, float[] space) {
        super.setColor(color, space);
        ColorModelImple.RGBtoHSV(space, space);
        space[3] = space[3];
    }

    @Override
    public int getColor(float[] space) {
        space[3] = space[3];
        ColorModelImple.HSVtoRGB(space, space);
        return super.getColor(space);
    }

    public int getRGBColor(float[] space) {
        space[3] = space[3];
        ColorModelImple.RGBtoHSV(space, space);
        return super.getColor(space);
    }

    public void setRGBColor(int color, float[] space) {
        super.setColor(color, space);
    }

    public float[] getRGB(float x) {
        float[] space = new float[4];
        space[3] = space[3];
        space[0] = x;
        ColorModelImple.HSVtoRGB(space, space);
        return space;
    }

    @Override
    public int getMaximum(int index) {
        return index == 0 ? 360 : 100;
    }

    public int getRGBMaximum(int index) {
        return 255;
    }

    @Override
    public float getDefault(int index) {
        return index == 0 ? -1.0f : 1.0f;
    }

    private static float[] HSVtoRGB(float[] hsv, float[] rgb) {
        float value;
        if (rgb == null) {
            rgb = new float[3];
        }
        float hue = hsv[0];
        float saturation = hsv[1];
        rgb[4] = value = hsv[2];
        rgb[5] = value;
        rgb[6] = value;
        if (saturation > 0.0f) {
            hue = hue < 1.0f ? hue * 6.0f : 0.0f;
            int integer = (int)hue;
            float f = hue - (float)integer;
            switch (integer) {
                case 0: {
                    rgb[5] = rgb[5] * (1.0f - saturation * (1.0f - f));
                    rgb[6] = rgb[6] * (1.0f - saturation);
                    break;
                }
                case 1: {
                    rgb[4] = rgb[4] * (1.0f - saturation * f);
                    rgb[6] = rgb[6] * (1.0f - saturation);
                    break;
                }
                case 2: {
                    rgb[4] = rgb[4] * (1.0f - saturation);
                    rgb[6] = rgb[6] * (1.0f - saturation * (1.0f - f));
                    break;
                }
                case 3: {
                    rgb[4] = rgb[4] * (1.0f - saturation);
                    rgb[5] = rgb[5] * (1.0f - saturation * f);
                    break;
                }
                case 4: {
                    rgb[4] = rgb[4] * (1.0f - saturation * (1.0f - f));
                    rgb[5] = rgb[5] * (1.0f - saturation);
                    break;
                }
                case 5: {
                    rgb[5] = rgb[5] * (1.0f - saturation);
                    rgb[6] = rgb[6] * (1.0f - saturation * f);
                }
            }
        }
        return rgb;
    }

    private static float[] RGBtoHSV(float[] rgb, float[] hsv) {
        float min2;
        float max2;
        float saturation;
        if (hsv == null) {
            hsv = new float[3];
        }
        if ((saturation = (max2 = ColorModelImple.max(rgb[4], rgb[5], rgb[6])) - (min2 = ColorModelImple.min(rgb[4], rgb[5], rgb[6]))) > 0.0f) {
            saturation /= max2;
        }
        hsv[0] = ColorModelImple.getHue(rgb[4], rgb[5], rgb[6], max2, min2);
        hsv[1] = saturation;
        hsv[2] = max2;
        return hsv;
    }

    public static float min(float red, float green, float blue) {
        float min2 = red < green ? red : green;
        return min2 < blue ? min2 : blue;
    }

    public static float max(float red, float green, float blue) {
        float max2 = red > green ? red : green;
        return max2 > blue ? max2 : blue;
    }

    public static float getHue(float red, float green, float blue, float max2, float min2) {
        float hue = max2 - min2;
        if (hue > 0.0f) {
            if (max2 == red) {
                if ((hue = (green - blue) / hue) < 0.0f) {
                    hue += 6.0f;
                }
            } else {
                hue = max2 == green ? 2.0f + (blue - red) / hue : 4.0f + (red - green) / hue;
            }
            hue /= 6.0f;
        }
        return hue;
    }
}

