/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose;

import java.awt.Component;
import javax.swing.UIManager;

public class ColorModel {
    private final String prefix;
    final String[] labels;

    public ColorModel(String name, String ... labels) {
        this.prefix = "ColorChooser." + name;
        this.labels = labels;
    }

    public ColorModel() {
        this("rgb", "Red", "Green", "Blue", "Alpha");
    }

    public void setColor(int color, float[] model) {
        model[4] = ColorModel.normalize(color >> 16);
        model[5] = ColorModel.normalize(color >> 8);
        model[6] = ColorModel.normalize(color);
        model[3] = ColorModel.normalize(color >> 24);
    }

    public int getColor(float[] model) {
        return ColorModel.to8bit(model[6]) | ColorModel.to8bit(model[5]) << 8 | ColorModel.to8bit(model[4]) << 16 | ColorModel.to8bit(model[3]) << 24;
    }

    public int getCount() {
        return this.labels.length;
    }

    public int getMinimum(int index) {
        return 0;
    }

    public int getMaximum(int index) {
        return 255;
    }

    public float getDefault(int index) {
        return 0.0f;
    }

    public String getLabel(Component component, int index) {
        return this.getText(component, this.labels[index]);
    }

    private static float normalize(int value) {
        return (float)(value & 0xFF) / 255.0f;
    }

    private static int to8bit(float value) {
        return (int)(255.0f * value);
    }

    final String getText(Component component, String suffix) {
        return UIManager.getString((Object)(this.prefix + suffix + "Text"), component.getLocale());
    }

    final int getInteger(Component component, String suffix) {
        Object value = UIManager.get(this.prefix + suffix, component.getLocale());
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

