/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.colorChoose;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.colorChoose.ColorModelImple;
import com.immomo.mmpaas.colorChoose.view.AbstractColorChooserPanelX;
import com.immomo.mmpaas.colorChoose.view.ColorPanel;
import com.immomo.mmpaas.colorChoose.view.DiagramComponent;
import com.immomo.mmpaas.utils.ColorConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;

public class ColorChooserPanelX
extends AbstractColorChooserPanelX
implements PropertyChangeListener {
    private static final int MASK = -16777216;
    private ColorModelImple model;
    private final ColorPanel panel;
    private final DiagramComponent slider;
    private final DiagramComponent diagram;
    private ColorChangeLisntener lisntener;
    private boolean isDragging = false;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorChooserPanelX.this.isDragging = false;
            ColorChooserPanelX.this.notifyColor();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorChooserPanelX.this.isDragging = true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ColorChooserPanelX.this.isDragging = true;
        }
    };

    private void notifyColor() {
        Color color = this.getColorFromModel();
        if (color != null && this.lisntener != null) {
            this.lisntener.onColorChange(color);
        }
    }

    public ColorChooserPanelX(ColorModelImple model) {
        this.model = model;
        this.panel = new ColorPanel(this.model);
        this.slider = new DiagramComponent(this.panel, false, this.mouseAdapter);
        this.diagram = new DiagramComponent(this.panel, true, this.mouseAdapter);
        this.setBackground(Application.getApplicationContext().getTheme().backgroundColor);
        this.panel.setBackground(ColorConstants.TRANSPARENT);
    }

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        if (color != null) {
            this.panel.setColor(color);
            this.slider.repaint();
            this.diagram.repaint();
            if (this.lisntener != null && !this.isDragging) {
                this.lisntener.onColorChange(color);
            }
        }
    }

    @Override
    protected void buildChooser() {
        if (0 == this.getComponentCount()) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weighty = 1.0;
            gbc.insets.bottom = 16;
            this.add((Component)this.panel, gbc);
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weighty = 1.0;
            gbc.ipadx = this.getPreferredSize().width;
            gbc.ipady = 20;
            gbc.insets.left = 16;
            gbc.insets.right = 16;
            gbc.insets.top = 16;
            gbc.insets.bottom = 16;
            this.add((Component)this.slider, gbc);
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weighty = 1.0;
            gbc.ipadx = this.getPreferredSize().width;
            gbc.ipady = 100;
            gbc.insets.left = 0;
            gbc.insets.right = 0;
            gbc.insets.top = 0;
            gbc.insets.bottom = 0;
            this.add((Component)this.diagram, gbc);
            ColorChooserPanelX.setInheritsPopupMenu(this, true);
        }
        this.panel.buildPanel();
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public int getMnemonic() {
        return this.model.getInteger(this, "Mnemonic");
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.model.getInteger(this, "DisplayedMnemonicIndex");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object;
        ColorSelectionModel model = this.getColorSelectionModel();
        if (model != null && (object = event.getNewValue()) instanceof Integer) {
            int value = 0xFF000000 & model.getSelectedColor().getRGB() | (Integer)object;
            model.setSelectedColor(new Color(value, true));
        }
    }

    private static void setInheritsPopupMenu(JComponent component, boolean value) {
        component.setInheritsPopupMenu(value);
        for (Component object : component.getComponents()) {
            if (!(object instanceof JComponent)) continue;
            ColorChooserPanelX.setInheritsPopupMenu((JComponent)object, value);
        }
    }

    public void setColorChangeLisntener(ColorChangeLisntener lisntener) {
        this.lisntener = lisntener;
    }

    public static interface ColorChangeLisntener {
        public void onColorChange(Color var1);
    }
}

