/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.code.generator;

import com.immomo.mlservics.utils.ColorUtils;
import com.immomo.mmpaas.code.generator.Generator;
import com.immomo.mmpaas.code.interfaces.ILabelCode;
import java.awt.Color;

public class LabelGenerator
extends Generator
implements ILabelCode {
    private static final String TEXT_ALIGN = "text_align";
    private static final String FONT_SIZE = "font_size";
    private static final String LINES = "lines";
    private static final String FONT_STYLE = "font_style";
    private static final String LINE_SPACE = "line_spacing";
    private static final String BREAK_MODE = "break_mode";

    public LabelGenerator() {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("view", "Label()");
    }

    @Override
    public void addText(String text) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("text", "'" + text + "'");
    }

    @Override
    public void addTextAlign(int textAlign) {
        if (this.codeMap == null) {
            return;
        }
        switch (textAlign) {
            case 19: {
                this.codeMap.remove(TEXT_ALIGN);
                break;
            }
            case 17: {
                this.codeMap.put(TEXT_ALIGN, "TextAlign.CENTER");
                break;
            }
            case 21: {
                this.codeMap.put(TEXT_ALIGN, "TextAlign.RIGHT");
            }
        }
    }

    @Override
    public void addTextSize(int size) {
        if (this.codeMap == null) {
            return;
        }
        if (size == 16) {
            this.codeMap.remove(FONT_SIZE);
        } else {
            this.codeMap.put(FONT_SIZE, String.valueOf(size));
        }
    }

    @Override
    public void addTextColor(Color color) {
        if (this.codeMap == null) {
            return;
        }
        this.codeMap.put("text_color", "'" + ColorUtils.hex(color) + "'");
    }

    @Override
    public void addLines(int lines) {
        if (this.codeMap == null) {
            return;
        }
        if (lines == 0) {
            this.codeMap.remove(LINES);
        } else {
            this.codeMap.put(LINES, String.valueOf(lines));
        }
    }

    @Override
    public void addTextFontStyle(int fontStyle) {
        if (this.codeMap == null) {
            return;
        }
        switch (fontStyle) {
            case 2: {
                this.codeMap.put(FONT_STYLE, "FontStyle.BOLD");
                break;
            }
            case 1: {
                this.codeMap.put(FONT_STYLE, "FontStyle.ITALIC");
                break;
            }
            case 0: {
                this.codeMap.remove(FONT_STYLE);
                break;
            }
            case 3: {
                this.codeMap.put(FONT_STYLE, "FontStyle.BOLD_ITALIC");
            }
        }
    }

    @Override
    public void addLineSpacing(float spacing) {
        if (this.codeMap == null) {
            return;
        }
        if (spacing == 0.0f) {
            this.codeMap.remove(LINE_SPACE);
        } else {
            this.codeMap.put(LINE_SPACE, String.valueOf(spacing));
        }
    }

    @Override
    public void addBreakMode(int breakMode) {
        if (this.codeMap == null) {
            return;
        }
        switch (breakMode) {
            case 0: {
                this.codeMap.put(BREAK_MODE, "BreakMode.CLIPPING");
                break;
            }
            case 1: {
                this.codeMap.remove(BREAK_MODE);
                break;
            }
            case 2: {
                this.codeMap.put(BREAK_MODE, "BreakMode.HEAD");
                break;
            }
            case 3: {
                this.codeMap.put(BREAK_MODE, "BreakMode.MIDDLE");
            }
        }
    }
}

